#ifndef PHOTON_H
#define PHOTON_H

#include "lrt.h"
#include "geometry.h"
#include "color.h"

class Photon 
{
  public:

  Photon() { axis = 78; /* to help in debugging */ 
	           tagged = false; }
  
  static const char XAXIS = 0;
  static const char YAXIS = 1;
  static const char ZAXIS = 2;

  // this is the constant of the cone filter applied to
  // reduce blurring affects (page 8 of Henrik paper)
  static const Float k = 1.0f;
  
  Ray ray;        // holds both position and 
                  // direction of incidence (pointing outward)
  Spectrum power; // power or energy of photon
  char  axis;     // for use in kd-tree
  bool tagged;    // used for rendering photons during debugging
  
};

#endif // PHOTON_H 
