#ifndef CAUSTIC_PHOTON_MAP_H
#define CAUSTIC_PHOTON_MAP_H
#include "lrt.h"
#include "photon.h"
#include "scene.h"
#include "geometry.h"

class CausticPhotonMap 
{
  public:
	
  CausticPhotonMap(int numbOfPhotons);
  ~CausticPhotonMap();
  
  void generatePhotonMap(Scene &scene); 
  
  // must delete returned vector of photon pointers when done with it!!!
  // yes, you better use delete instead of free !!!
  // also, number returned might not be number asked for
  // returns: a pair, the first being the distance SQUARED, the 
  //   second being a pointer to the photon 
  vector< pair<Float,Photon *> >* 
  getNearestPhotons(Point &point, int numberOfPhotonsWanted, 
    Float distance = 100 );


  // for debugging
	void printPhotonDim();
  void printPhotons();

  private:
  
  Photon* photons;
  //Photon** photonTree;
  vector<Photon*> photonTree;
  Float maxDistance2; // max distance squared
  int numberOfPhotonsWanted;
  int photonDepth;
  
  int numberOfPhotons;

  bool getPhotonPosition(Ray* ray, const Scene& scene);
  
  void balancePhotonMap();
  
  //void locatePhoton(int first, int last, const Point &point, 
  bool locatePhoton(int first, int last, const Point &point, 
    vector< pair<Float, Photon *> > &pq);

  // check if this is returning the correct logic !!!
  static bool comparePhotonDistance(const pair<Float,Photon*> &ph1, 
    const pair<Float,Photon*> &ph2)
  {
    //if (ph1.first < ph2.first) { return false; }
    //else { return true; }
    return (ph1.first < ph2.first);
  }

};

#endif // CAUSTIC_PHOTON_MAP_H 
