#include "kdtree.h"


//void KDTree::balance(int start, int end, vector<Photon*> photons)
void KDTree::balance(int start, int end, Photon* photons[])
{
  // check if start > end
  if (start >= end) { return; }

  Float xmin=photons[start]->ray.O.x; 
  Float ymin=photons[start]->ray.O.y; 
  Float zmin=photons[start]->ray.O.z; 
	Float xmax = xmin;
	Float ymax = ymin;
	Float zmax = zmin;

  // get bounding box
  for (int i= start+1; i<= end; i++)
  {
    if (xmin > photons[i]->ray.O.x) { xmin = photons[i]->ray.O.x; }
    else if (xmax < photons[i]->ray.O.x) { xmax = photons[i]->ray.O.x; }
    
    if (ymin > photons[i]->ray.O.y) { ymin = photons[i]->ray.O.y; }
    else if (ymax < photons[i]->ray.O.y) { ymax = photons[i]->ray.O.y; }
    
    if (zmin > photons[i]->ray.O.z) { zmin = photons[i]->ray.O.z; }
    else if (zmax < photons[i]->ray.O.z) { zmax = photons[i]->ray.O.z; }
  }
  
  assert(xmin <= xmax);
  assert(ymin <= ymax);
  assert(zmin <= zmax);

  // get max dim
  Float tempDim;
  Float maxDim = xmax - xmin;
  char maxAxis = Photon::XAXIS;
  if ((tempDim=ymax-ymin) > maxDim) 
  { maxDim = tempDim; maxAxis = Photon::YAXIS; } 
  if ((tempDim=zmax-zmin) > maxDim) 
  { maxDim = tempDim; maxAxis = Photon::ZAXIS; } 
  
  // compute median
  int median = (start+end)/2;

  // sort along that dim
  switch (maxAxis)
  { 
   case Photon::XAXIS:
     qsort((void *)(photons+start),end-start+1,sizeof(Photon*),
       (int (*)(const void *, const void *))KDTree::compareX);
     photons[median]->axis = Photon::XAXIS;
     break;
   case Photon::YAXIS:
     qsort((void *)(photons+start),end-start+1,sizeof(Photon*),
       (int (*)(const void *, const void *))KDTree::compareY);
     photons[median]->axis = Photon::YAXIS;
     break;
   case Photon::ZAXIS:
     qsort((void *)(photons+start),end-start+1,sizeof(Photon*),
       (int (*)(const void *, const void *))KDTree::compareZ);
     photons[median]->axis = Photon::ZAXIS;
     break;
  }

  // recurse
  cerr << "-";
  balance(start,median-1,photons);
  cerr << "+";
  balance(median+1,end,photons);
}

