#ifndef KDTREE_H
#define KDTREE_H

#include "lrt.h"
#include "photon.h"

class KDTree
{
  public:

  static void balance(int start, int end, Photon* photons[]);
  //static void balance(int start, int end, list<Photon*> photons);

  private:

  //static bool compareX(Photon* pht1, Photon* pht2);
  //static bool compareY(Photon* pht1, Photon* pht2);
  //static bool compareZ(Photon* pht1, Photon* pht2);
  //static bool KDTree::compareX(const Photon* pht1, const Photon* pht2)
  static int compareX(const void* pht1, const void* pht2)
  { 
    if (((Photon*)pht1)->ray.O.x < ((Photon*)pht2)->ray.O.x) { return -1; }
    else if (((Photon*)pht1)->ray.O.x > ((Photon*)pht2)->ray.O.x) { return 1; }
    else { return 0; }
  }
  
  //static bool KDTree::compareY(const Photon* pht1, const Photon* pht2)
  static int compareY(const void* pht1, const void* pht2)
  { 
    if (((Photon*)pht1)->ray.O.y < ((Photon*)pht2)->ray.O.y) { return -1; }
    else if (((Photon*)pht1)->ray.O.y > ((Photon*)pht2)->ray.O.y) { return 1; }
    else { return 0; }
  }
  
  //static bool KDTree::compareZ(const Photon* pht1, const Photon* pht2);
  static int compareZ(const void* pht1, const void* pht2)
  { 
    if (((Photon*)pht1)->ray.O.z < ((Photon*)pht2)->ray.O.z) { return -1; }
    else if (((Photon*)pht1)->ray.O.z > ((Photon*)pht2)->ray.O.z) { return 1; }
    else { return 0; }
  }

};

#endif // KDTREE_H 
