#include "kdtreecc.h"

void KDTreeCC::balance(const vector<Photon*>::iterator &start,
  const vector<Photon*>::iterator &end, vector<Photon*> &photons)
{
  // check if start > end
  if (start >= end) { return; }

  Float xmin=(*start)->ray.O.x; 
  Float ymin=(*start)->ray.O.y; 
  Float zmin=(*start)->ray.O.z; 
	Float xmax = xmin;
	Float ymax = ymin;
	Float zmax = zmin;

  vector<Photon*>::iterator iter = start;

  // get bounding box
  for (; iter != end; iter++) 
  {
    if (xmin > (*iter)->ray.O.x) { xmin = (*iter)->ray.O.x; }
    else if (xmax < (*iter)->ray.O.x) { xmax = (*iter)->ray.O.x; }
    
    if (ymin > (*iter)->ray.O.y) { ymin = (*iter)->ray.O.y; }
    else if (ymax < (*iter)->ray.O.y) { ymax = (*iter)->ray.O.y; }
    
    if (zmin > (*iter)->ray.O.z) { zmin = (*iter)->ray.O.z; }
    else if (zmax < (*iter)->ray.O.z) { zmax = (*iter)->ray.O.z; }
  }
  
  assert(xmin <= xmax);
  assert(ymin <= ymax);
  assert(zmin <= zmax);

  // get max dim
  Float tempDim;
  Float maxDim = xmax - xmin;
  char maxAxis = Photon::XAXIS;
  if ((tempDim=ymax-ymin) > maxDim) 
  { maxDim = tempDim; maxAxis = Photon::YAXIS; } 
  if ((tempDim=zmax-zmin) > maxDim) 
  { maxDim = tempDim; maxAxis = Photon::ZAXIS; } 
  
  // compute median
  //int median = distance(start,end-1)/2;
  vector<Photon*>::iterator median = start +
	  distance(start,end-1)/2;

  // sort along that dim
  switch (maxAxis)
  { 
   case Photon::XAXIS:
     std::sort(start, end, KDTreeCC::compareX);
     //photons[median]->axis = Photon::XAXIS;
     (*median)->axis = Photon::XAXIS;
     break;
   case Photon::YAXIS:
     std::sort(start, end, KDTreeCC::compareY);
     //photons[median]->axis = Photon::YAXIS;
     (*median)->axis = Photon::YAXIS;
     break;
   case Photon::ZAXIS:
     std::sort(start, end, KDTreeCC::compareZ);
     //photons[median]->axis = Photon::ZAXIS;
     (*median)->axis = Photon::ZAXIS;
     break;
  }

  // recurse
  //cerr << "-";
  //balance(start,start+median,photons);
  balance(start,median,photons);
  //cerr << "+";
  //balance(start+median+1,end,photons);
  balance(median+1,end,photons);
}

