#ifndef KDTREECC_H
#define KDTREECC_H

#include "lrt.h"
#include "photon.h"
#include <algorithm>

class KDTreeCC
{
  public:

  //static void balance(int start, int end, Photon* photons[]);
  static void balance(const vector<Photon*>::iterator &start,
    const vector<Photon*>::iterator &end, vector<Photon*> &photons);

  private:
  
  public:
  static bool compareX(Photon* pht1 , Photon* pht2)
  { return (pht1->ray.O.x < pht2->ray.O.x); }
  
  static bool compareY(Photon* pht1 , Photon* pht2)
  { return (pht1->ray.O.y < pht2->ray.O.y); }
 
  static bool compareZ(Photon* pht1 , Photon* pht2)
  { return (pht1->ray.O.z < pht2->ray.O.z); }

};

#endif // KDTREECC_H 
