#include <iostream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define M_PI           3.14159265358979323846 
#define PI2DEG         (180./M_PI)
#define DEG2PI         (M_PI/180.)

int main(int argc, char** argv)
{
  if (argc < 5)
  { 
    cerr << "usgage: makeWater dimX dimY freq ampl" << endl; 
    exit(-1);
  }

  int dimX = atoi(argv[1]);
  int dimY = atoi(argv[2]);
  float freq = atof(argv[3]);
  float ampl = atof(argv[4]);

  cerr << "dimX:" << dimX;
  cerr << " dimY:" << dimY << endl;
  cerr << "freq:" << freq 
    << " ampl:" << ampl << endl;
  

  FILE* heightFile = fopen("water.rib","w"); 
  fprintf(heightFile,
    "PatchMesh \"bilinear\" %d \"nonperiodic\" %d \"nonperiodic\" \"Pz\" [\n",
    dimX, dimY); 

  for (int i =0 ; i<dimX; i++)
  {
   for (int j =0 ; j<dimY; j++)
   {
     float height = ampl*sin(2*M_PI*freq*i/dimX)
       *sin(2*M_PI*freq*j/dimY);

     fprintf(heightFile,"%f ", height);
   }
   fprintf(heightFile,"\n");
  }
  fprintf(heightFile,"]\nAttributeEnd\nWorldEnd");

  return 0;  
}



