
#ifndef REFLECTION_H
#define REFLECTION_H
#include "lrt.h"
#include "geometry.h"

class BRDF {
  public:

	virtual ~ BRDF();

	virtual Spectrum fr(const Vector & wi) const = 0;
	
  virtual Float photonfr(const Vector & wi) const; 

	virtual int SpecularComponents() const;
	
        virtual int TransmissionComponents() const;

	virtual Spectrum SampleSpecular(int component, Vector * wo) const;
	
        virtual Spectrum SampleTransmission(int component, Vector * wo) const;

	virtual Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const =
		0;

	virtual Float Pdf(const Vector & wi) const = 0;

};

class Lambertian:public BRDF { public:
	 Lambertian(const Spectrum & reflectance, const Normal & normal) {
		R = reflectance;
		N = normal;
	} 
  
  Spectrum fr(const Vector & wi) const;
  
  Float photonfr(const Vector & wi) const; 

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:

	Spectrum R;
	Normal N;

};

class BlinnGlossy:public BRDF { public:
	 BlinnGlossy(const Spectrum & reflectance, Float roughness,
				 const Normal & normal, const Vector & wo);

	Spectrum fr(const Vector & wi) const;
	
  Float photonfr(const Vector & wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:
	 Spectrum R;
	Float invRoughness;
	Vector wo;
	Normal N;
	Float costhetao;

};

class SpecularReflection:public BRDF { public:
	 SpecularReflection(const Spectrum & r,
						const Normal & N, const Vector & wi);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} 
  
  int SpecularComponents() const {
		return 1;
	} 
  
  Spectrum SampleSpecular(int component, Vector * wi) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } private:

	 Spectrum R;
	Vector reflectedDirection;

};

class SpecularTransmission:public BRDF {
  public:

	SpecularTransmission(const Spectrum & r,
						 const Normal & N,
						 const Vector & wo, Float indexi, Float indext);

	Spectrum fr(const Vector &) const {
		return Spectrum(0.);
	} int SpecularComponents() const {
		return 1;
	} Spectrum SampleSpecular(int component, Vector * wo) const;

  int TransmissionComponents() const
  { return 1; }

  Spectrum SampleTransmission(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const {
		*pdf = 0.;
		return Spectrum(0.);
	} Float Pdf(const Vector & wi) const {
		return 0.;
  } private:

	 Spectrum R;
	Vector DirT;

};

class ScatteringMixture:public BRDF {
  public:

	ScatteringMixture():numSpecular(0),numTransmission(0) {
	} void AddFunction(BRDF * func, Float weight = 1.0) {
		funcs.push_back(func);
		weights.push_back(weight);
		numSpecular += func->SpecularComponents();
    numTransmission += func->TransmissionComponents();
	} ~ScatteringMixture();

	int SpecularComponents() const {
		return numSpecular;
	} 
  
  Spectrum fr(const Vector & wi) const;
  
  Float photonfr(const Vector & wi) const;
	
  int TransmissionComponents() const {
		return numTransmission;
  }

	Spectrum SampleSpecular(int component, Vector * wo) const;
	
  Spectrum SampleTransmission(int component, Vector * wo) const;

	Spectrum Sample(Float u[2], Vector * wi, Float * pdf) const;

	Float Pdf(const Vector & wi) const;

  private:

	vector < BRDF * >funcs;
	vector < Float > weights;
	int numSpecular;
  int numTransmission;

};

#if 0
class Lafortune:public BRDF { public:
	 Lafortune(int nLobes, const LafortuneLobe lobes[], const Vector & wi,
			   const Normal & N, const Vector & dPdu);

	~Lafortune() {
		delete[]lobes;
	} Spectrum fr(const Vector &) const;

  private:

	int nLobes;
	LafortuneLobe *lobes;
	Normal N;
	Vector wo;
	Vector dPdu, dPdv;

};
#endif

#endif // REFLECTION_H
