
#ifndef SCENE_H
#define SCENE_H

#include "photonmap.h"

class Scene 
{
 public:
  
  Scene();
  
  void AddPrimitives(const vector < Primitive * >&prim);
  
  void AddLights(const list < Light * >&lightList);
  
  const vector < Primitive * >& GetPrimitives();
  
  const list < Light * >& GetLights();
  
  void Render();
  
  ~Scene();
  
  bool Intersect(const Ray & ray, Float mint, Float * maxt,
		 HitInfo * hit) const;
  
  bool Unoccluded(const Point &, const Point &) const;
  bool Unoccluded(const Ray &) const;
  
  Camera                 *camera;
  Image                  *image;
  JitterSampler          *sampler;
  CausticPhotonMap       *causticPhotonMap;
  VolumePhotonMap        *volumePhotonMap;

  RtToken IlluminationIntegrator;
  
 private:
  Accelerator * accelerator;
  vector < Primitive * >primitives;
  list < Light * >lights;
  
};

#endif // SCENE_H
