
#include "lrt.h"
#include "sl.h"
#ifndef WIN32
#include <dlfcn.h>
#endif

SLTriple LrtSLAmbient(RmanShaderParams & params)
{
	Spectrum amb(0);

	const list < Light * >&lights =
		params.hitInfo->hitPrim->attributes->Lights;
	list < Light * >::const_iterator iter;
	for (iter = lights.begin(); iter != lights.end(); iter++) {
		Assert(1 == 0);			// MMP hack for getting 348 a3 out the door
#if 0
		const Light *lt = *iter;
		if (lt->IsAmbient()) {
			Point dummy;
			amb += lt->Sample(params.sampleGenerator, dummy, &dummy);
		}
#endif
	}
	return SLTriple(amb);
}

SLTriple SLTriple::FaceForward(const SLTriple & t)
{
	if (Dot(*this, t) < 0)
		return SLTriple(-a, -b, -c);
	else
		return SLTriple(a, b, c);
}

DSO::DSO(const char *filename)
{
#ifdef WIN32
	hinstLib = LoadLibrary(filename);
#else
	hinstLib = dlopen(filename, RTLD_LAZY);
	if (!hinstLib) {
		Warning("DL error: %s", dlerror());
	}
#endif
}

void *DSO::GetSym(const char *symbol) const
{
	if (!hinstLib)
		return NULL;
#ifdef WIN32
	return GetProcAddress(hinstLib, symbol);
#else
	return dlsym(hinstLib, symbol);
#endif
}
