% [knowncams,newcampos,newcamangles] = camsfrompoints (M, persp, campos, camangles, knownpoints)
function [knowncams,newcampos,newcamangles] = camsfrompoints (M, persp, campos, camangles, knownpoints)

m = length(M.images);
n = M.maxpoint;

knownindex = zeros(1,n);
knownindex(knownpoints(:,1)) = 1:size(knownpoints,1);
imageindex = zeros(1,n);

opts = optimset('fminunc');
opts = optimset (opts, 'Display', 'off', 'Diagnostics', 'off');
opts = optimset (opts, 'MaxFunEvals', 5000, 'TolFun', 1e-6, 'TolX', 1e-6);

knowncams = [];
newcampos = campos;
newcamangles = camangles;

for i = 1:m
  imagepts = M.images(i).imagepoints(:,1);
  imageindex(imagepts) = 1:length(imagepts);

  commonpts = intersect (knownpoints(:,1), imagepts);
  if length(commonpts) >= 3
    photoxy = M.images(i).imagepoints(imageindex(commonpts),[2 3]);
    w = M.images(i).width;
    h = M.images(i).height;
	projxy = zeros(size(photoxy));
    projxy(:,1) =  2*(photoxy(:,1)-w/2)/w;
    projxy(:,2) = -2*(photoxy(:,2)-h/2)/w;
    spacexyz = knownpoints(knownindex(commonpts),[2 3 4]);
	weights = knownpoints(knownindex(commonpts),5).^.5;
    cam0 = [1000*campos(i,:) camangles(i,:)]';
    warning off;
    [cam, f, exitflag] = fminunc (@evalsinglecam, cam0, opts, persp, projxy, spacexyz, weights);
	cam(1:3) = cam(1:3)/1000;
    warning on;
    if exitflag > 0
	  if cam(4) < -180
        cam(4) = cam(4) + 360;
      elseif cam(4) > 180
        cam(4) = cam(4) - 360;
      end
	  if cam(5) < -180
	    cam(5) = cam(5) + 360;
      elseif cam(5) > 180
        cam(5) = cam(5) - 360;
      end
	  if cam(6) < -180
	    cam(6) = cam(6) + 360;
      elseif cam(6) > 180 
	    cam(6) = cam(6) - 360;
      end
	  knowncams(end+1,:) = [i cam' 1/(1000*max(0,f)^.5/sum(weights)+.0100000001)];
	  %knowncams(end+1,:) = [i cam' 1/(max(0,f)+.00100000001)];
      newcampos(i,:) = cam(1:3)';
      newcamangles(i,:) = cam(4:6)';
	  fprintf(1,'camera %d solved to %g\n', i, f);
	else
	  fprintf(1,'failed to solve camera %d\n', i);
	end
  end
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function f = evalsinglecam (cam, persp, projxy, spacexyz, weights)

cam(1:3) = cam(1:3)/1000;

sh = sin(pi/180*cam(4)); ch = cos(pi/180*cam(4)); % heading
sp = sin(pi/180*cam(5)); cp = cos(pi/180*cam(5)); % pitch
sr = sin(pi/180*cam(6)); cr = cos(pi/180*cam(6)); % roll
camR = [1 0 0; 0 cr -sr; 0 sr cr] * [cp -sp 0; sp cp 0; 0 0 1] * [ch 0 sh; 0 1 0; -sh 0 ch];
 
f = 0;
for j = 1:size(spacexyz,1)
  transxyz = spacexyz(j,:)'-cam(1:3);
  xyz = camR*transxyz;
  if xyz(1) > 0
    projx = persp*(xyz(3)/xyz(1));
    projy = persp*(xyz(2)/xyz(1));
    f = f + weights(j)*((projxy(j,1)-projx)^2 + (projxy(j,2)-projy)^2);
  else
    f = f + 1e3*xyz(1)^2;
  end
end 

% penalties on position - I know roughly where the positions could be
if abs(cam(1)) > 18
  f = f + 1e3*(abs(cam(1))-18)^2;
end
if cam(2) < 1.3
  f = f + 1e3*(cam(2)-1.3)^2;
elseif cam(2) > 2.2
  f = f + 1e3*(cam(2)-2.2)^2;
end
if abs(cam(3)) > 18
  f = f + 1e3*(abs(cam(3))-18)^2;
end
% penalties on angles - I don't want the iteration going unbounded here
if cam(4) < -720
  f = f + (cam(4)+720)^2;
elseif cam(4) > 720
  f = f + (cam(4)-720)^2;
end
if cam(5) < -720
  f = f + (cam(5)+720)^2;
elseif cam(5) > 720
  f = f + (cam(5)-720)^2;
end
if cam(6) < -720
  f = f + (cam(6)+720)^2;
elseif cam(6) > 720
  f = f + (cam(6)-720)^2;
end

