% showsolve (M, i, persp, campos, camangles, points)
function showsolve (M, i, persp, campos, camangles, points)

showimg(M,i,1);
hold on;

cam = [campos(i,:) camangles(i,:)];
sh = sin(pi/180*cam(4)); ch = cos(pi/180*cam(4)); % heading
sp = sin(pi/180*cam(5)); cp = cos(pi/180*cam(5)); % pitch
sr = sin(pi/180*cam(6)); cr = cos(pi/180*cam(6)); % roll
camR = [1 0 0; 0 cr -sr; 0 sr cr] * [cp -sp 0; sp cp 0; 0 0 1] * [ch 0 sh; 0 1 0; -sh 0 ch];
   
photo = M.images(i);
w = photo.width;
h = photo.height;

for j = 1:size(photo.imagepoints,1)
  id = photo.imagepoints(j,1);
  transxyz = (points(id,:)-campos(i,:))';
  xyz = camR*transxyz;
  if xyz(1) > 0
    projx = persp*(xyz(3)/xyz(1));
    projy = persp*(xyz(2)/xyz(1));
    screenx = .5*w*(projx+1);
    screeny = -w*.5*projy+h/2;
    plot(screenx,screeny,'go');
    handle = text(screenx+6,screeny,int2str(id));
    set(handle,'color',[0 1 0]);
  end
end 

hold off;

