#ifndef CAMERA_H
#define CAMERA_H
#include "lrt.h"
#include "color.h"
#include "sampling.h"
#include "geometry.h"
#include "transform.h"
class Camera {
public:
	Camera(const Transform &world2cam, const Transform &proj,
		Float hither, float yon, Film *film);
	virtual ~Camera() { }
	Film *GetFilm() const { return film; }
	virtual bool GenerateRay(Float sample[5],
		Ray &ray) const = 0;
	virtual void AdjustAutomatically (const Scene *scene) = 0;

//protected:
	#if 0
	RtToken ShutterType;
	Float IrisRate;
	Float StripeWidth;
	RtToken StripeDirection;
	#endif
	Float ClipHither, ClipYon;
	Float invClipHither;
	Film *film;
	Transform WorldToCamera;
	Transform CameraToScreen;
	Transform CameraToWorld;
	Transform RasterToCamera;
	Transform WorldToScreen;
};
class PerspectiveCamera : public Camera {
public:
	PerspectiveCamera(const Transform &world2cam,
			Float hither, Float yon, Float fov,
			Film *film);
	bool GenerateRay(Float sample[5], Ray &) const;
	void AdjustAutomatically (const Scene *scene) {}
};
class OrthoCamera : public Camera {
public:
	OrthoCamera(const Transform &world2cam,
			Float hither, Float yon, Film *film);
	bool GenerateRay(Float sample[5], Ray &) const;
	void AdjustAutomatically (const Scene *scene) {}
};
#endif // CAMERA_H
