#include "illuminationmap.h"
#include "primitives.h"
#include "texture.h"

IlluminationMap::
IlluminationMap (const Transform &o2w, Float ps, Texture<Spectrum> *it, bool dv = true)
	: powerscaling(ps), illumtex(it), ObjectToWorld(o2w), directlyVisible(dv)
{
	WorldToObject = Transform(ObjectToWorld.GetInverse());
}


IlluminationMap::
~IlluminationMap (void)
{
	delete illumtex;
}


Spectrum IlluminationMap::
L (const Ray &r) const
{
	Ray ray = WorldToObject(r);
	Float longitude, latitude, xzmag;
	xzmag = sqrt(ray.D.x*ray.D.x + ray.D.z*ray.D.z);
	if (xzmag == 0) {
		longitude = 0;
		if (ray.D.y < 0) latitude = 1; else latitude = 0;
	} else {
		longitude = (atan2 (ray.D.z, ray.D.x)+M_PI)/(2*M_PI);
		latitude = (-atan (ray.D.y/xzmag)+.5*M_PI)/M_PI;
	}
	Surf surf;
	surf.dgShading = DifferentialGeometry(Point(),Normal(),Vector(),Vector(),1-longitude,latitude);
	return powerscaling * illumtex->evaluate(&surf);
}

