#ifndef LRT_H
#define LRT_H
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <list>
using std::list;
#include <vector>
using std::vector;
#include <utility>
using std::make_pair;
#ifndef __GNUG__
#include <pair.h>
#endif // !__GNUG__
using std::pair;
#include <algorithm>
using std::min;
using std::max;
using std::swap;
typedef float Float;
typedef unsigned char u_char;
typedef unsigned short u_short;
typedef unsigned int u_int;
typedef unsigned long u_long;
class Scene;
class Primitive;
class GeometricPrimitive;
struct Surf;
class Vector;
class Point;
class Normal;
class Ray;
class BBox;
class Transform;
class Shape;
struct DifferentialGeometry;
class PrimitiveSet;
class GridAccelerator;
class HBVAccelerator;
class HBVNode;
class Camera;
class PerspectiveCamera;
class OrthoCamera;
class MbDOFPerspectiveCamera;
class Film;
class ColorFilm;
class BWFilm;
class DepthFilm;
class Image;
class Imager;
class Sampler;
class JitterSampler;
class GeneralSampler;
class Filter;
class BoxFilter;
class TriangleFilter;
class GaussianFilter;
class MitchellFilter;
class GeneralFilter;
class Spectrum;
class Material;
class Matte;
class Plastic;
class Glass;
class ShinyMetal;
template <class T> class Texture;
template <class T> class MixTexture;
template <class T> class BilerpTexture;
class UVTexture;
class TextureMap;
class BxDF;
class LambertianReflection;
class LambertianTransmission;
class Microfacet;
class MicrofacetDistribution;
class SpecularReflection;
class SpecularTransmission;
class BSDF;
class Light;
class PointLight;
class InfinitePointLight;
class AreaLight;
class InfiniteAreaLight;
class AmbientLight;
class Integrator;
class RayCastingIntegrator;
class WhittedIntegrator;
class PathIntegrator;
class MCIntegrator;
class IlluminationMap;
#define LRT_VERSION 1.0
#define STATS_NONE 0
#define STATS_BASIC 1
#define STATS_DETAILED 2
#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif
#define INV_255 .00392156862745098039
#define INFINITY HUGE_VAL
#ifdef __GNUG__
#define PRINTF_FORMAT __attribute__ ((__format__ (__printf__, 1, 2)))
#else
#define PRINTF_FORMAT
#endif // __GNUG__
extern void Info(const char *, ...) PRINTF_FORMAT;
extern void Warning(const char *, ...) PRINTF_FORMAT;
extern void Error(const char *, ...) PRINTF_FORMAT;
extern void Severe(const char *, ...) PRINTF_FORMAT;
extern void StatsRegisterCounter(int level, const char *category,
                                 const char *name, int *ptr);
extern void StatsRegisterRatio(int level, const char *category,
                               const char *name, int *pa, int *pb);
extern void StatsPrint(int level, FILE *dest);
extern void StatsCleanup();
void MatrixInvert( Float m[4][4], Float minv[4][4] );
extern Float RandomFloat(Float min = 0., Float max = 1.);
Point Lerp(Float t, const Point &p1, const Point &p2);
extern Transform Translate(const Vector &delta);
extern Transform RotateX(Float angle);
extern Transform RotateY(Float angle);
extern Transform RotateZ(Float angle);
extern Transform Rotate(Float angle, const Vector &axis);
extern Transform Scale(Float x, Float y, Float z);
extern Transform Orthographic(Float near, Float far);
extern Transform Frustum(Float left, Float right,
						 Float bottom, Float top,
						 Float near, Float far);
extern Transform Perspective(Float fovy, Float aspect,
							 Float znear, Float zfar);
extern TextureMap *GetTexture(const char *filename);
extern Spectrum *TIFFRead(const char *name, int *xSize, int *ySize);
extern void TIFFWrite8Bit(const char *name, Float *RGB, Float *alpha,
	int XRes, int YRes);
extern void TIFFWriteFloat(const char *name, Float *RGB, Float *alpha,
	int XRes, int YRes);
extern bool ParseRIB(const char *filename);
extern void ParseEnableDebug();
class StringHashTable {
public:
	u_int Hash(const char *str) const;
	void *Search(const char *key) const;
	void Add(const char *key, void *data);
private:
	static const int NUM_BUCKETS = 1047;
	typedef list<pair<const char *, void *> > ItemType;
	ItemType buckets[NUM_BUCKETS];
};
#ifdef NDEBUG
#define Assert(expr) ((void)0)
#else
#define Assert(expr) \
    ((expr) ? (void)0 : Severe("Assertion " #expr " failed in %s, line %d", \
                            __FILE__, __LINE__))
#endif // NDEBUG
inline Float Lerp(Float pos, Float start, Float end) {
	return (1. - pos) * start + pos * end;
}
inline Float Clamp(Float val, Float low, Float high) {
	if (val < low) return low;
	else if (val > high) return high;
	else return val;
}
inline int Clamp(int val, int low, int high) {
	if (val < low) return low;
	else if (val > high) return high;
	else return val;
}
inline int Step(Float stepPos, Float val) {
    if (val < stepPos) return 0;
    else               return 1;
}
inline Float SmoothStep(Float min, Float max, Float value) {
	Float v = Clamp((value - min) / (max - min), 0., 1.);
	return -2. * v * v * v + 3. * v * v;
}
inline int Round(Float val) {
	return (int)rint(val);
}
inline int Mod(int a, int b) {
    int n = int(a/b);
    a -= n*b;
    if (a < 0)
        a += b;
    return a;
}
inline Float Radians(Float deg) { return (M_PI/180.) * deg; }
inline Float Degrees(Float rad) { return (180./M_PI) * rad; }
inline char *Strdup(const char *str) {
	char *ret = new char[strlen(str) + 1];
	strcpy(ret, str);
	return ret;
}
#ifdef __GNUC__
#define RI_UNIMP() { static int first = 1 ; \
	if (first) { \
		first = 0; \
		Warning( "call to unimplemented function %s!", __PRETTY_FUNCTION__ ); } }
#else
#define RI_UNIMP() { static int first = 1 ; \
	if (first) { first = 0; Warning( "call to unimplemented function!"); } }
#endif
#endif // LRT_H
