#include "lrt.h"
#include "primitives.h"
#include "light.h"
Primitive::~Primitive() { }

bool Primitive::CanIntersect() const {
	return true;
}

void Primitive::Refine(vector<Primitive *> &refined) const {
	Severe("Unimplemented Primitive::Refine method called!");
}
BBox GeometricPrimitive::BoundWorldSpace() const {
	return shape->BoundWorldSpace();
}
bool GeometricPrimitive::IntersectP(const Ray &r) const {
	return shape->IntersectP( r );
}
bool GeometricPrimitive::CanIntersect() const {
	return shape->CanIntersect();
}
void GeometricPrimitive::Refine(vector<Primitive *> &refined) const {
	vector<Shape *> r;
	shape->Refine(r);
	for (u_int i = 0; i < r.size(); ++i) {
		GeometricPrimitive *gp = new GeometricPrimitive(r[i],
			material, areaLight);
		refined.push_back(gp);
	}
}
GeometricPrimitive::GeometricPrimitive(Shape *s, Material *m,
		AreaLight *a) {
	shape = s;
	material = m;
	areaLight = a;
}
bool GeometricPrimitive::Intersect(const Ray &r, Surf *surf, bool directFromEye) const {
	if (directFromEye && !shape->directlyVisible)
		return false;
	if (shape->Intersect(r, &surf->dgGeom)) {
		surf->dgShading = material->bump(surf->dgGeom);
		surf->primitive = this;
		return true;
	}
	return false;
}
PrimitiveSet::PrimitiveSet(const vector<Primitive *> &p)
	: prims(p), bounds(p[0]->BoundWorldSpace()) {
	for (u_int i = 1; i < prims.size(); ++i)
		bounds = Union(bounds, prims[i]->BoundWorldSpace());
}
const Primitive *PrimitiveSet::GetPrim( int i ) const {
	return prims[i];
}
BSDF *Surf::getBSDF() const {
	return primitive->material->getBSDF(this);
}
Spectrum Surf::Le(const Vector &wo) const {
	if (primitive->areaLight)
		return primitive->areaLight->L(dgGeom.P, wo);
	else return Spectrum(0.);
}
