%{

#define YY_MAIN 0

#include "lrt.h"
#include "ri.h"

struct RIB_array;

#include "ribparse.h"
extern int line_num;
int str_pos;

void add_string_char( char c )
{
	yylval.string[str_pos++] = c;
	yylval.string[str_pos] = '\0';
}

extern void ParseError( const char *format, ... ) PRINTF_FORMAT;
%}
%option nounput
WHITESPACE [ \t
]+
NUMBER [-+]?([0-9]+|(([0-9]+\.[0-9]*)|(\.[0-9]+))([eE][-+]?[0-9]+)?)
IDENT [a-zA-Z_][a-zA-Z_0-9]*
%x STR COMMENT
%%
"#" { BEGIN COMMENT; }
<COMMENT>. /* eat it up */
<COMMENT>\n { line_num++; BEGIN INITIAL; }
AreaLightSource		{ return AREALIGHTSOURCE;	}
Atmosphere			{ return ATMOSPHERE; 		}
AttributeBegin 		{ return ATTRIBUTEBEGIN; 	}
AttributeEnd 		{ return ATTRIBUTEEND; 		}
Attribute			{ return ATTRIBUTE;			}
Basis				{ return BASIS;				}
Bound				{ return BOUND;				}
Clipping 			{ return CLIPPING; 			}
Color				{ return COLOR;				}
ColorSamples		{ return COLORSAMPLES;		}
ConcatTransform 	{ return CONCATTRANSFORM; 	}
Cone				{ return CONE;				}
CoordinateSystem	{ return COORDINATESYSTEM;	}
CropWindow			{ return CROPWINDOW;		}
Cylinder			{ return CYLINDER;			}
Declare 			{ return DECLARE; 			}
Deformation			{ return DEFORMATION;		}
DepthOfField		{ return DEPTHOFFIELD;		}
DetailRange			{ return DETAILRANGE;		}
Detail				{ return DETAIL;			}
Disk				{ return DISK;				}
Displacement		{ return DISPLACEMENT;		}
Display 			{ return DISPLAY; 			}
Exposure			{ return EXPOSURE;			}
Exterior			{ return EXTERIOR;			}
Format 				{ return FORMAT; 			}
FrameAspectRatio 	{ return FRAMEASPECTRATIO; 	}
FrameBegin 			{ return FRAMEBEGIN; 		}
FrameEnd 			{ return FRAMEEND; 			}
GeneralPolygon		{ return GENERALPOLYGON;	}
GeometricApproximation	{ return GEOMETRICAPPROXIMATION;	}
Geometry			{ return GEOMETRY;			}
Hider				{ return HIDER;				}
Hyperboloid			{ return HYPERBOLOID;		}
Identity			{ return IDENTITY;			}
Illuminate			{ return ILLUMINATE;		}
Imager 				{ return IMAGER;			}
Interior 			{ return INTERIOR;			}
LightSource 		{ return LIGHTSOURCE;		}
MakeBump 			{ return MAKEBUMP;			}
MakeCubeFaceEnvrionment { return MAKECUBEFACEENVIRONMENT;			}
MakeLatLongEnvironment { return MAKELATLONGENVIRONMENT;			}
IlluminationMap		{ return ILLUMINATIONMAP; }
MakeShadow 			{ return MAKESHADOW;		}
MakeTexture 		{ return MAKETEXTURE;		}
Matte 				{ return MATTE;				}
MotionBegin 		{ return MOTIONBEGIN;		}
MotionEnd 			{ return MOTIONEND;			}
NuPatch 			{ return NUPATCH;			}
ObjectBegin 		{ return OBJECTBEGIN;		}
ObjectEnd 			{ return OBJECTEND;			}
ObjectInstance 		{ return OBJECTINSTANCE;	}
Opacity 			{ return OPACITY;			}
Option 				{ return OPTION; 			}
Orientation 		{ return ORIENTATION;		}
Paraboloid 			{ return PARABOLOID;			}
PatchMesh 			{ return PATCHMESH;			}
FastLevelSet		{ return FASTLEVELSET;		}
Patch 				{ return PATCH;				}
Perspective			{ return PERSPECTIVE;		}
PixelFilter 		{ return PIXELFILTER; 		}
PixelSamples 		{ return PIXELSAMPLES; 		}
PixelVariance 		{ return PIXELVARIANCE;		}
PointsGeneralPolygons { return POINTSGENERALPOLYGONS;		}
PointsPolygons		{ return POINTSPOLYGONS;	}
Polygon 			{ return POLYGON; 			}
Projection 			{ return PROJECTION; 		}
Quantize 			{ return QUANTIZE;			}
RelativeDetail 		{ return RELATIVEDETAIL;	}
ReverseOrientation 	{ return REVERSEORIENTATION;}
Rotate 				{ return ROTATE;			}
Scale 				{ return SCALE; 			}
ScreenWindow 		{ return SCREENWINDOW; 		}
ShadingInterpolation { return SHADINGINTERPOLATION;		}
ShadingRate 		{ return SHADINGRATE; 		}
Shutter 			{ return SHUTTER;			}
Sides 				{ return SIDES;				}
Skew 				{ return SKEW;				}
SolidBegin 			{ return SOLIDBEGIN;		}
SolidEnd 			{ return SOLIDEND;			}
Sphere 				{ return SPHERE; 			}
Surface				{ return SURFACE;			}
TextureCoordinates 	{ return TEXTURECOORDINATES;}
Torus 				{ return TORUS;				}
TransformBegin 		{ return TRANSFORMBEGIN;	}
TransformEnd 		{ return TRANSFORMEND;		}
Transform 			{ return TRANSFORM;			}
Translate 			{ return TRANSLATE; 		}
TrimCurve 			{ return TRIMCURVE;			}
version 			{ return VERSION; 			}
WorldBegin 			{ return WORLDBEGIN; 		}
WorldEnd 			{ return WORLDEND; 			}
{WHITESPACE} /* do nothing */
\n { line_num++; }
{NUMBER} {
  yylval.num = atof(yytext);
  return NUM;
}
{IDENT} {
	strcpy( yylval.string, yytext );
	return ID;
}
"[" { return LBRACK; }
"]" { return RBRACK; }
"-" { return DASH; }
\" { BEGIN STR; str_pos = 0; }
<STR>\\n {add_string_char('\n');}
<STR>\\t {add_string_char('\t');}
<STR>\\r {add_string_char('\r');}
<STR>\\b {add_string_char('\b');}
<STR>\\f {add_string_char('\f');}
<STR>\\\" {add_string_char('\"');}
<STR>\\\\ {add_string_char('\\');}
<STR>\\[0-9]{3} {
  int val = atoi(yytext+1);
  while(val > 256)
    val -= 256;
  add_string_char(val);
}
<STR>\\\n {line_num++;}
<STR>\\. { add_string_char(yytext[1]);}
<STR>\" {BEGIN INITIAL; return STRING;}
<STR>. {add_string_char(yytext[0]);}
<STR>\n {ParseError("Unterminated string!");}

. { ParseError( "Illegal character: %c",yytext[0] ); }
%%
