#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"
class Integrator {
public:
	virtual ~Integrator();
	virtual Spectrum L(const Scene *scene,
		const Ray &ray,	Float *alpha, bool directFromEye) const = 0;
};
class RayCastingIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray,
		Float *alpha, bool directFromEye) const;
};
class WhittedIntegrator : public Integrator {
public:
	WhittedIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha, bool directFromEye) const;
	static int RayDepth;
private:
	int MaxDepth;
};
class PathIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha, bool directFromEye) const;
};
class MCIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha, bool directFromEye) const;
};
#endif // TRANSPORT_H
