#ifndef CAMERA_H
#define CAMERA_H
#include "lrt.h"
#include "color.h"
#include "sampling.h"
#include "geometry.h"
#include "transform.h"
class Camera {
public:
	Camera(const Transform &world2cam, const Transform &proj,
		Float hither, float yon, Film *film);
	virtual ~Camera() { }
	Film *GetFilm() const { return film; }
	virtual bool GenerateRay(Float sample[5],
		Ray &ray) const = 0;
	virtual void Calibrate(Scene *scene, Integrator *integrator) {}
	virtual Float ApertureScaleFactor(Float z) {return 0;}
	virtual Float AreaOfConfusion(Float z) {return 0;}
	virtual Float ConfusionAtInfinity() {return 0;}
	virtual void LensToPoint(Float u, Float v, Point p, Ray& ray) {}
	virtual void FromLensParallelTo(Float u, Float v,
					Vector dir, Ray &result) {}
	virtual void TraceToFilm(Ray& r, Float &xRaster, Float&yRaster) {}

//protected:
	#if 0
	RtToken ShutterType;
	Float IrisRate;
	Float StripeWidth;
	RtToken StripeDirection;
	#endif
	Float ClipHither, ClipYon;
	Float invClipHither;
	Film *film;
	Transform WorldToCamera;
	Transform CameraToScreen;
	Transform CameraToWorld;
	Transform RasterToCamera;
	Transform WorldToScreen;
};
class PerspectiveCamera : public Camera {
public:
	PerspectiveCamera(const Transform &world2cam,
			Float hither, Float yon, Float fov,
			Film *film);
	bool GenerateRay(Float sample[5], Ray &) const;
};
class OrthoCamera : public Camera {
public:
	OrthoCamera(const Transform &world2cam,
			Float hither, Float yon, Film *film);
	bool GenerateRay(Float sample[5], Ray &) const;
};
#endif // CAMERA_H
