#include "camera.h"

class MbDOFPerspectiveCamera : public Camera {
public:
  MbDOFPerspectiveCamera(const Transform *world2cam, int nTransforms,
			 Float hither, Float yon, 
			 Float shutterOpen, float shutterClose,
			 Float fstop, 
			 Float focalLen, 
			 Float focalDist, 
			 RtToken mode, 
			 Float fov,
			 Film *film);
	~MbDOFPerspectiveCamera() {};
	virtual bool GenerateRay(Float sample[5], Ray &ray) const;
	virtual void Calibrate(Scene *scene, Integrator *integrator);
	void ShutterPriorityCalibrate(Point *orig, int n, Float z0, Float z1,
				      Float *b, int m, Float bbar);
	void AperturePriorityCalibrate(Point *orig, Point *shift, int n,
				       Float z0, Float z1, Float *b, int m);
	void ProgrammedCalibrate(Point *orig, Point *shift, int n,
				 Float z0, Float z1, Float *b, int m,
				 Float bbar);
	Point *HitArray(Scene *scene, Float left, Float right,
			Float top, Float bottom, int nx, int ny,
			Point * &shifted);
	Float Brightness(Scene *scene, Integrator *integrator,
			 Float left, Float right,
			 Float top, Float bottom,
			 int nx, int ny, Float * &b);
	virtual Float ApertureScaleFactor(Float z);
	virtual Float AreaOfConfusion(Float z);
	virtual Float ConfusionAtInfinity();
	virtual void LensToPoint(Float u, Float v, Point p, Ray& ray);
	virtual void FromLensParallelTo(Float u, Float v,
					Vector dir, Ray &result);
	virtual void TraceToFilm(Ray& r, Float& xRaster, Float& yRaster);
private:
	Transform WorldToCamera0, WorldToCamera1, CameraToWorld0,
	  CameraToWorld1;
	Float ShutterStart, ShutterEnd;
	Float FStop, FocalLength, FocalDistance, ApertureRadius;
	Float x0, x1, y0, y1;
	Float xRasterRatio, yRasterRatio, RasterAreaOverFocalPlaneArea;
	RtToken Mode;
};
