#ifndef MATERIALS_H
#define MATERIALS_H
#include "lrt.h"
#include "primitives.h"
class Material {
public:
	virtual ~Material() { }
	virtual BSDF *getBSDF(const Surf *surf) const = 0;
	virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;
};
class Matte : public Material {
public:
	Matte(Texture<Spectrum> *kd) {
		Kd = kd;
	}
	~Matte();
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd;
};
class Plastic : public Material {
public:
	~Plastic();
	Plastic(Texture<Spectrum> *kd, Texture<Spectrum> *ks,
			Texture<Float> *rough) {
		Kd = kd;
		Ks = ks;
		roughness = rough;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd, *Ks;
	Texture<Float> *roughness;
};
class Glass : public Material {
public:
	~Glass();
	Glass(Texture<Spectrum> *r, Texture<Spectrum> *t,
			Texture<Float> *i) {
		Kr = r;
		Kt = t;
		index = i;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kr, *Kt;
	Texture<Float> *index;
};
class ShinyMetal : public Material {
public:
	~ShinyMetal();
	ShinyMetal(Texture<Spectrum> *ks, Texture<Float> *rough,
			Texture<Spectrum> *kr) {
		Ks = ks;
		roughness = rough;
		Kr = kr;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Ks, *Kr;
	Texture<Float> *roughness;
};



class ThinFilm : public Material {
public:
	~ThinFilm();
	ThinFilm(Texture<Spectrum> *kr, Texture<Spectrum> *kd, Texture<Float> *thick,
		 Texture<Float> *trans, Texture<Float> *mod) {
		Kr = kr;
		Kd = kd;
		thickness = thick;
		transmission = trans;
		modulation = mod;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kr, *Kd;
	Texture<Float> *thickness, *modulation;
	Texture<Float> *transmission;
};

#endif // MATERIALS_H
