#include "ri.h"
#include "mbdofcamera.h"
#include "film.h"

MbDOFPerspectiveCamera::MbDOFPerspectiveCamera(const Transform *world2cam,
		int nTransforms, Float hither, Float yon,
		Float shutterOpen, float shutterClose,
		Float fstop, Float focalLen, Float focalDist,
		RtToken mode, Float fov, Film *film)
	: Camera(world2cam[0],
		Perspective(fov, 1. / 1. /*scene->image->PixelAspectRatio*/,
			hither, yon) * Scale(-1, -1, 1),
		hither, yon, film) {
  
        WorldToCamera0 = world2cam[0];
	if(nTransforms > 1) {
	  WorldToCamera1 = world2cam[1];
	} else {
	  WorldToCamera1 = world2cam[0];
	}

	ShutterStart = shutterOpen;
	ShutterEnd = shutterClose;
	FStop = fstop;
	FocalLength = focalLen;
	FocalDistance = focalDist;
	Mode = mode;
	cerr << "Camera Mode=" << Mode << endl;
	if(Mode!=LRT_MANUAL)
	  Warning("MbDOFPerspectiveCamera - only manual mode supported (so far).");

	// Adjust for exposure ... For part 3, you'll need to compute
	// your FStop and ShutterEnd before setting this.
	film->image->Gain *= ShutterEnd/(FStop*FStop);
}


bool MbDOFPerspectiveCamera::GenerateRay(Float sample[5], Ray &ray) const {
        return false;
}
