#ifndef NURBS_H
#define NURBS_H
#include "lrt.h"
#include "shapes.h"
#ifndef _WIN32
#include <alloca.h>
#endif
class NURBS : public Shape {
public:
	NURBS(const Transform &o2w, int nu, int uorder, Float *uknot,
		Float umin, Float umax,
		int nv, int vorder, Float *vknot, Float vmin, Float vmax,
		Float *P, bool isHomogeneous, bool isFilm = false, bool
		bump = false, bool noise = false);
	~NURBS();
	virtual BBox Bound() const;
	virtual BBox BoundWorldSpace() const;
	virtual bool CanIntersect() const { return false; }
	virtual void Refine(vector<Shape *> &refined) const;
private:
	int nu, uorder, nv, vorder;
	Float umin, umax, vmin, vmax;
	Float *uknot, *vknot;
	bool isHomogeneous, isFilm, isBump, isNoise;
	Float *P;
	static const Float thickness[2501];
};
#endif // NURBS_H
