#ifndef TRANSPORT_H
#define TRANSPORT_H
#include "lrt.h"
class Integrator {
public:
	virtual ~Integrator();
	virtual Spectrum L(const Scene *scene,
		const Ray &ray,	Float *alpha) const = 0;
};
class RayCastingIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray,
		Float *alpha) const;
};
class WhittedIntegrator : public Integrator {
public:
	WhittedIntegrator(int md) {
		MaxDepth = md;
	}
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha = NULL) const;
	static int RayDepth;
private:
	int MaxDepth;
};
class PathIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
};
class MCIntegrator : public Integrator {
public:
	Spectrum L(const Scene *scene, const Ray &ray, Float *alpha) const;
};
#endif // TRANSPORT_H
