#include "lrt.h"
#include "camera.h"
#include "image.h"
#include "film.h"
Camera::Camera(const Transform &world2cam, const Transform &proj,
		Float hither, Float yon, Film *film)
{
	this->film = film;
	ClipHither = hither;
	ClipYon = yon;
	invClipHither = 1. / ClipHither;
	WorldToCamera = world2cam;
	CameraToWorld = Transform(WorldToCamera.GetInverse());
	
	CameraToScreen = proj;
	Transform ScreenToCamera = Transform(CameraToScreen.GetInverse());
	
	WorldToScreen = CameraToScreen * WorldToCamera;
	RasterToCamera = ScreenToCamera * film->GetRasterToScreen();
}
PerspectiveCamera::PerspectiveCamera(const Transform &world2cam,
		Float hither, Float yon, Float fov,
		Film *film)
	: Camera(world2cam,
		Perspective(fov, 1. / 1. /*scene->image->PixelAspectRatio*/,
			hither, yon) * Scale(-1, -1, 1),
		hither, yon, film)
{
}
OrthoCamera::OrthoCamera(const Transform &world2cam,
		Float hither, Float yon, Film *film)
	: Camera(world2cam, Orthographic(hither, yon),
		 hither, yon, film)
{
}
bool OrthoCamera::GenerateRay(Float sample[5], Ray &ray) const {
	if (sample[0] < film->GetImage()->SampleCropLeft ||
		sample[0] > film->GetImage()->SampleCropRight ||
		sample[1] < film->GetImage()->SampleCropBottom ||
		sample[1] > film->GetImage()->SampleCropTop)
		return false;
	Point Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));
	ray = CameraToWorld(Ray(Pcamera, Vector(0,0,1)));
	return true;
}
bool PerspectiveCamera::GenerateRay(Float sample[5], Ray &ray) const {
	if (sample[0] < film->GetImage()->SampleCropLeft ||
		sample[0] > film->GetImage()->SampleCropRight ||
		sample[1] < film->GetImage()->SampleCropBottom ||
		sample[1] > film->GetImage()->SampleCropTop)
		return false;
	Point Pcamera = RasterToCamera(Point(sample[0], sample[1], 0));
	ray = Ray(Point(0, 0, 0), Vector(Pcamera.x, Pcamera.y, Pcamera.z));
	ray.D *= invClipHither;
	ray = CameraToWorld(ray);
	return true;
}
