#include "lrt.h"
#include "ri.h"

#include "light.h"

// TK: add time_of_day argument to LRT
float time_of_day = 13.5;

int num_photons = 300000;
int photons_per_estimate = 500;
float max_photon_distance = 10;
int env_rays = 256;

int main(int argc, char *argv[]) {
// TK: remove this sky preview block
#if 0 // preview the sky to raw image files
  FILE *outfile;
  char filename[32];
  unsigned char *img = (unsigned char *)malloc(3*90*360*sizeof(char));
  int frame = 0;
  for (float t = 5.5; t <= 21.5; t += 0.5) {
    EnvironmentLight *e = new EnvironmentLight(false, Transform(), Spectrum(0.), t);
    frame++;
  for (int phi = 0; phi < 90; phi++) {
    int rowBase = phi*360;
    for (int theta = 0; theta < 360; theta++) {
      float rgb[3];
      Spectrum s = e->E(theta*M_PI/180.0, phi*M_PI/180.0);
      s /= 600.;
      s.ConvertToRGB(rgb);
      rgb[0] = Round(rgb[0]*255.);
      rgb[1] = Round(rgb[1]*255.);
      rgb[2] = Round(rgb[2]*255.);
      img[((rowBase+theta)*3) + 0] = (int)Clamp(rgb[0], 0., 255.);
      img[((rowBase+theta)*3) + 1] = (int)Clamp(rgb[1], 0., 255.);
      img[((rowBase+theta)*3) + 2] = (int)Clamp(rgb[2], 0., 255.);
    }
  }
  sprintf(filename, "%s00%d%d.raw", "sky", frame/10, frame%10);
  cerr << "writing: " << filename << endl;
  outfile = fopen(filename, "wb");
  fwrite(img, 90*360, 3, outfile);
  fclose(outfile);
  delete e;
  }
#else // normal...
  if (argc > 2) {
    time_of_day = atof(argv[2]);
    if (argc > 4) {
      num_photons = atoi(argv[3]);
      photons_per_estimate = atoi(argv[4]);
      argc -= 2;
    }
    argc--;
  }
	fprintf(stderr, "lrt version %1.3f of %s at %s\n", LRT_VERSION,
                __DATE__, __TIME__);
	if (getenv( "LRT_YYDEBUG" ) != NULL)
		ParseEnableDebug();
	RiBegin(RI_NULL);
	if (argc == 1) {
		ParseRIB("-");
	} else {
		for (int i = 1 ; i < argc ; i++) {
			if (!ParseRIB(argv[i]))
				Error("Couldn't open %s\n", argv[i]);
		}
	}
	RiEnd();
#endif
	return 0;
}
