#include "film.h"
Film::Film(Image *image, Float left, Float right, Float top,
		Float bottom) {
	this->image = image;
	ScreenLeft = left;
	ScreenRight = right;
	ScreenTop = top;
	ScreenBottom = bottom;
	ScreenToRaster =
		Scale(image->GetXResolution(), image->GetYResolution(), 1.) *
		Scale(1. / (ScreenRight - ScreenLeft),
			1. / (ScreenBottom - ScreenTop), 1.) *
		Translate(Vector(-ScreenLeft, -ScreenTop, 0.));
	RasterToScreen = Transform(ScreenToRaster.GetInverse());
}

Film::~Film() {
	delete image;
}
void ColorFilm::AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha) {
	image->AddSample(PRas, radiance, alpha);
}
void BWFilm::AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha) {
	Float I = radiance.Intensity();
	Spectrum intensity(I,I,I);
	image->AddSample( PRas, intensity, alpha );
}
void DepthFilm::AddSample(const Point &PRas, const Spectrum &radiance,
		Float alpha ) {
	Spectrum depth(PRas.z,PRas.z,PRas.z);
	image->AddSample(PRas, depth, alpha);
}
