#ifndef HEIGHTFIELD_H
#define HEIGHTFIELD_H
#include "shapes.h"

#define HW2
#define PHONG_INTERPOLATE

#ifdef HW2
/*This Structure stores x,y,z and normal for each vertex*/
typedef struct {
  Point P;
  Normal N;
} vertexInfo;
#endif

class Heightfield : public Shape {
public:
	Heightfield(const Transform &o2w, int nu, int nv, float *zs);
	~Heightfield();
	
#ifdef HW2
	virtual bool Intersect(const Ray &r, DifferentialGeometry *dg) const;
#else
	virtual bool CanIntersect() const;
	virtual void Refine(vector<Shape *> &refined) const;
#endif

	virtual BBox Bound() const;
private:
	float *z;
	int nx, ny;

#ifdef HW2
	float minz, maxz;
	float InvNumX, InvNumY;
	vertexInfo** heightField;
#endif
};

#endif
