#include "light.h"
#include "primitives.h"
#include "color.h"
#include "scene.h"
Light::~Light() {
}
Spectrum Light::dE(const Scene *scene,
	const DifferentialGeometry &dg,	const Vector &w) const {
	return Spectrum(0.);
}
Spectrum Light::dE(const Scene *scene,
	const DifferentialGeometry &dg,	Vector *w) const {
	*w = Vector(0,0,0);
	return Spectrum(0.);
}
bool Light::visible(const Scene *scene, const Point &x1,
	const Point &x2) const {
	if (!CastsShadows) return 1.;
	Ray r(x1, x2-x1, 1e-3, .999);
	return scene->IntersectP(r) ? false : true;
}
float Light::unoccluded(const Scene *scene, const Point &x,
		const Vector &w) const {
	if (!CastsShadows) return 1.;
	Ray r(x, w, 1e-3);
	return scene->IntersectP(r) ? 0. : 1.;
}
PointLight::PointLight(bool shadows, const Transform &world2light,
	const Spectrum &power, const Point &Plight)
	: Light(shadows, world2light, power) {
	lightPos = LightToWorld(Plight);
}
Spectrum PointLight::dE(const Scene *scene,
		const DifferentialGeometry &dg,	Vector *w) const {
	*w = lightPos - dg.P;
	w->Normalize();
	if (visible(scene, dg.P, lightPos))
		return I(*w) * fabs(Dot(*w, dg.N)) /
			DistanceSquared(lightPos, dg.P);
	return Spectrum(0.);
}
InfinitePointLight::InfinitePointLight(bool shadows,
	const Transform &world2light, const Spectrum &power,
	const Vector &dir)
	: Light(shadows, world2light, power) {
	lightDir = LightToWorld(dir);
}
Spectrum InfinitePointLight::dE(const Scene *scene,
		const DifferentialGeometry &dg,	Vector *w) const {
	*w = - lightDir;
	w->Normalize();
	return unoccluded(scene, dg.P, *w) *
		Power * fabs(Dot(*w, dg.N));
}
AreaLight::AreaLight(bool shadows, const Transform &world2light,
	const Spectrum &power, Shape *s)
	: Light(shadows, world2light, power) {
	shape = s;
	Area = shape->area();
}
Spectrum AreaLight::dE(const Scene *scene,
		const DifferentialGeometry &dg,	const Vector &w) const {
	DifferentialGeometry hit;
	Ray ray(dg.P, w);
	if (shape->Intersect(ray, &hit) &&
		visible( scene, dg.P, hit.P ))
	    return L(hit.P, -w);
	return 0.;
}
Spectrum InfiniteAreaLight::dE(const Scene *scene,
	 	const DifferentialGeometry &dg,	const Vector &w) const {
	return unoccluded(scene, dg.P, w) * Power *
		max(0.f, Dot(w, dg.N));
}
AmbientLight::AmbientLight(const Spectrum &p)
	: Light(false, Transform(), p) {
}
Spectrum AmbientLight::dE(const Scene *,
		const DifferentialGeometry &, const Vector &) const {
	return Power;
}

