#include "lrt.h"
#include "color.h"
#include "reflection.h"
#include "shapes.h"
#include <stdarg.h>
BSDF::BSDF(const DifferentialGeometry &dg, BxDF *r, ...)
	: N(dg.N), S(dg.S), T(dg.T)
{
	va_list args;
	va_start(args, r);
	while (r != NULL) {
		Float wt = va_arg(args, double);
		if (wt > 0) {
			bxdfs.push_back(r);
			weights.push_back(wt);
		}
		r = va_arg(args, BxDF *);
	}
}
BSDF::~BSDF() {
	for (u_int i = 0; i < bxdfs.size(); ++i)
		delete bxdfs[i];
}
int BSDF::NumSpecular() const {
	int n = 0;
	for (u_int i = 0; i < bxdfs.size(); ++i)
		if (bxdfs[i]->IsSpecular()) ++n;
	return n;
}
Spectrum BSDF::f(const Vector &wiW, const Vector &woW) const {
	Vector wi = WorldToLocal(wiW), wo = WorldToLocal(woW);
	Spectrum f = 0.;
	for (u_int i = 0; i < bxdfs.size(); ++i)
		f += weights[i] * bxdfs[i]->f(wi, wo);
	return f;
}
Spectrum BSDF::f_delta(int component, const Vector &w,
		Vector *wi) const {
	BxDF *spec = NULL;
	Float weight = 0.;
	for (u_int i = 0; i < bxdfs.size(); ++i) {
		if (bxdfs[i]->IsSpecular()) {
			if (component-- == 0) {
				spec = bxdfs[i];
				weight = weights[i];
				break;
			}
		}
	}
	if (spec) {
		Vector wo = WorldToLocal(w);
		Spectrum f = weight * spec->f_delta(wo, wi);
		*wi = LocalToWorld(*wi);
		return f;
	}
	return 0.;
}
Spectrum LambertianReflection::f(const Vector &wi,
		const Vector &wo) const {
	if (sameHemisphere(wi, wo))
		return R / M_PI;
	else
		return 0.;
}
Spectrum LambertianTransmission::f(const Vector &wi,
		const Vector &wo) const {
	if (!sameHemisphere(wi, wo))
		return T / M_PI;
	else
		return 0.;
}
Microfacet::Microfacet(const Spectrum &reflectance,
	MicrofacetDistribution *d) {
	R = reflectance;
	distribution = d;
}
Microfacet::~Microfacet() {
	delete distribution;
}
Spectrum Microfacet::f(const Vector &wi, const Vector &wo) const {
	if (sameHemisphere(wi, wo)) {
		Float cosThetaI = fabs(wi.z);
		Float cosThetaO = fabs(wo.z);
		return R * distribution->D(wi, wo) * G(wi, wo) *
			F(wi, wo) / (4. * cosThetaI * cosThetaO);
	}
	else return 0.;
}
SpecularReflection::SpecularReflection(const Spectrum &r) {
	R = r;
}
Spectrum SpecularReflection::f_delta(const Vector &wo,
		Vector *wi) const {
	*wi = Vector(-wo.x, -wo.y, wo.z);
	return R;
}
SpecularTransmission::SpecularTransmission(const Spectrum &r,
		Float indexi, Float indext) {
	R = r;
	eta = indexi / indext;
}
Spectrum SpecularTransmission::f_delta(const Vector &wo,
		Vector *wi) const {
	Float cosi = wo.z;
	Vector N(0,0,1);
	Float e = eta;
	if (cosi < 0.) {
		N = -N;
		cosi = -cosi;
		e = 1./eta;
	}

	Float cost = 1.0 - e * e * (1.0 - cosi * cosi);
	if (cost < 0.)
		return 0.; // *wi = Vector(-wo.x, -wo.y, wo.z);
	else {
		Float k = e * cosi - sqrtf(cost);
		*wi = k * N + e * -wo;
	}
	return R;
}
Spectrum BxDF::rho() const {
	return 0.f;
}

Spectrum BxDF::rho(const Vector &w) const {
	return 0.f;
}
