#include "scene.h"
#include "camera.h"
#include "primitives.h"
#include "image.h"
#include "transport.h"
#include "accel.h"
#include "sampling.h"
#ifdef PROJECT
#include <sys/time.h>
#endif

extern float heightMinZ;
extern Transform* transformHeightFromWorld;


Scene::~Scene() {
	delete camera;
	delete sampler;
	delete image;
	delete integrator;
}
Spectrum Scene::L(const Ray &ray) const {
	return integrator->L(this, ray, NULL);
}
bool Scene::IntersectP(const Ray &ray) const {
	return prims->IntersectP(ray);
}
Scene::Scene(Camera *cam, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &pr,
		const vector<Light *> &lts) {
	lights = lts;
	prims = new GridAccelerator(pr);
	camera = cam;
	image = img;
	sampler = s;
	integrator = in;
#ifdef PROJECT
	struct timeval time;
	gettimeofday(&time,NULL);
	srand(time.tv_sec);
	
#endif

}
void Scene::Render() {
	cerr << "Rendering: ";
	Float sample[5];
	while (sampler->GetNextImageSample(sample)) {
		Ray ray;
		if (!camera->GenerateRay(sample, ray))
			continue;
		static int eyeRaysTraced = 0;
		if (eyeRaysTraced == 0)
			StatsRegisterCounter(STATS_BASIC, "Camera", "Eye Rays Traced",
				&eyeRaysTraced);
		++eyeRaysTraced;
		if (eyeRaysTraced % 10000 == 0) cerr << '+';
		Float alpha;
		Spectrum L = integrator->L(this, ray, &alpha);
		Float screenz = camera->WorldToScreen(ray(ray.maxt)).z;
		if (screenz > 1.) {
			L = 0.;
			alpha = 0.;
		}
		Point Praster(sample[0], sample[1], screenz);
		image->AddSample(Praster, L, alpha);
	}
	image->Write();
	cerr << endl;
}

#ifdef  PROJECT
float getRefractiveIndex(Point refractionPoint,float baseZ)
{
    //return 1;
    
    baseZ= 0;   //heightfield hack
    
    
    float height= baseZ-refractionPoint.z;
        
    //float AMP = .01;

//    cout<<height<<endl;
    
    static float maxHeight= 1.0;

//    if(refractionPoint.y>.45)// +rand()/3.0/RAND_MAX*AMP)
//	return 10; 

    if(height>maxHeight)
    	return 1;
    else
	return (1-log(height/maxHeight)); // + rand()/1.0/RAND_MAX*AMP);
}


unsigned int findMin(float maxtX,float maxtY,float maxtZ)
{
    unsigned int index=1;
    if(maxtY<maxtX && maxtY<maxtZ)
	index=2;
    else
	if(maxtZ<maxtX && maxtZ<maxtY)
	index=3;
    return index;
}
#endif


bool Scene::Intersect(const Ray &ray, Surf *surf) const {
#ifdef  PROJECT

    ray.D= (ray.D).Hat();
    Ray temp(ray.O, ray.D);

//    cout<<(*transformHeightFromWorld)(temp.O).z<<endl;
    
    
    Point oldRefractionPoint;
    unsigned int noOfSteps= 2000; //00000;
    float xStep=.5, yStep=.5, zStep=.01;
    float maxtX, maxtY, maxtZ;
    unsigned int minIndex;
    float ettaOld,ettaNew,inputTheta,outputTheta,newSinAngle;

    float x,y,z, xyRatio,yzRatio,xzRatio;

    for (unsigned int count=0; count<noOfSteps; ++count)
    {
	Vector inputDirection= (*transformHeightFromWorld)(temp.D).Hat();

	if(fabs(inputDirection.x)>1e-6)
	    maxtX= xStep/fabs(inputDirection.x);
	else
	    maxtX= FLT_MAX;
       	if(fabs(inputDirection.y)>1e-6)
	    maxtY= yStep/fabs(inputDirection.y);
	else
	    maxtY= FLT_MAX;
	if(fabs(inputDirection.z)>1e-6)
	    maxtZ= zStep/fabs(inputDirection.z);
	else
	    maxtZ= FLT_MAX;

	minIndex= findMin(maxtX,maxtY,maxtZ);
	switch(minIndex)
	    {
		case 1: 
		    temp.maxt= maxtX;
		    break;
		case 2:
		    temp.maxt= maxtY;
		    break;
		case 3:
		    temp.maxt= maxtZ;
		    break;
		default:
		    cout<<"cant be true"<<endl;
		    exit(1);
	    }

	if (prims->Intersect(temp, surf))
	{
	    ray.O= temp.O;
	    ray.D= temp.D;
	    ray.mint= temp.mint;
	    ray.maxt= temp.maxt;
	    	    
	    return true;
	}
	else  
	{
	    temp.O= temp(temp.maxt);
	    Point refractionPoint= (*transformHeightFromWorld)(temp(temp.maxt));

	    if(!count)
		oldRefractionPoint= refractionPoint;
			    
	    if(refractionPoint.z<heightMinZ)
	    {
		ettaOld= getRefractiveIndex(oldRefractionPoint,heightMinZ);
		ettaNew= getRefractiveIndex(refractionPoint,heightMinZ);

		switch(minIndex)
		{
		    case 1: 
			inputTheta=
			    atan(sqrt(inputDirection.y*inputDirection.y+inputDirection.z*inputDirection.z) 
				 /fabs(inputDirection.x));
			break;
		    case 2:
			inputTheta=
			    atan(sqrt(inputDirection.x*inputDirection.x+inputDirection.z*inputDirection.z) 
				 /fabs(inputDirection.y));
			break;
		    case 3:
			inputTheta=
			    atan(sqrt(inputDirection.x*inputDirection.x+inputDirection.y*inputDirection.y) 
				 /fabs(inputDirection.z));
			break;
		    default:
			cout<<"cant be true"<<endl;
			exit(1);
		}

		newSinAngle= ettaOld*sin(inputTheta)/ettaNew;
			
		if (fabs(newSinAngle)>1)
		{
		    //total internal reflection
		    temp.D= inputDirection;

		    switch(minIndex)
		    {
			case 1: 
			    temp.D.x= -temp.D.x; 
			    break;
			case 2:
			    temp.D.y= -temp.D.y;
			    break;
			case 3:
			    temp.D.z= -temp.D.z;
			    break;
			default:
			    cout<<"cant be true"<<endl;
			    exit(1);
		    }
		    temp.D= (Transform(transformHeightFromWorld->GetInverse()))(temp.D);
		    temp.D= (temp.D).Hat();
		    oldRefractionPoint= refractionPoint;
		}
		else
		{
		    //refraction
		    outputTheta= asin(newSinAngle);
		    switch(minIndex)
		    {
			case 1: 
			    {
				x= cos(outputTheta);
				if((x>0 && inputDirection.x<0)||(x<0 && inputDirection.x>0))
				    x=-x;
				
				if(fabs(inputDirection.z)>1e-8) //check threshold.....
				{
				    yzRatio= inputDirection.y/inputDirection.z;
				    z= sin(outputTheta)/sqrt(1+yzRatio*yzRatio);
				    
				    if((z>0 && inputDirection.z<0)||(z<0 && inputDirection.z>0))
					z= -z;
				    
				    y= yzRatio*z;
				    temp.D= Vector(x,y,z).Hat();
				}
				else
				{
				    if(inputDirection.y<0)
					temp.D= Vector(x,-fabs(sin(outputTheta)),0).Hat();
				    else
					temp.D= Vector(x,fabs(sin(outputTheta)),0).Hat();
				} 
				break;
			    }
			    
			case 2:
			    {
				y= cos(outputTheta);
				if((y>0 && inputDirection.y<0)||(y<0 && inputDirection.y>0))
				    y=-y;
				
				if(fabs(inputDirection.z)>1e-8) //check threshold.....
				{
				    xzRatio= inputDirection.x/inputDirection.z;
				    z= sin(outputTheta)/sqrt(1+xzRatio*xzRatio);
				    
				    if((z>0 && inputDirection.z<0)||(z<0 && inputDirection.z>0))
					z= -z;
				    
				    x= xzRatio*z;
				    temp.D= Vector(x,y,z).Hat();
				}
				else
				{
				    if(inputDirection.x<0)
					temp.D= Vector(-fabs(sin(outputTheta)),y,0).Hat();
				    else
					temp.D= Vector(fabs(sin(outputTheta)),y,0).Hat();
				}
				break;
			    }
			    
			case 3:
			    {
				z= cos(outputTheta);
				if((z>0 && inputDirection.z<0)||(z<0 && inputDirection.z>0))
				    z=-z;
				
				if(fabs(inputDirection.y)>1e-8) //check threshold.....
				{
				    xyRatio= inputDirection.x/inputDirection.y;
				    y= sin(outputTheta)/sqrt(1+xyRatio*xyRatio);
				    
				    if((y>0 && inputDirection.y<0)||(y<0 && inputDirection.y>0))
					y= -y;
				    
				    x= xyRatio*y;
				    temp.D= Vector(x,y,z).Hat();
				}
				else
				{
				    if(inputDirection.x<0)
					temp.D= Vector(-fabs(sin(outputTheta)),0,z).Hat();
				    else
					temp.D= Vector(fabs(sin(outputTheta)),0,z).Hat();
				}
				break;
			    }
			    
			default:
			    cout<<"cant be true"<<endl;
			    exit(1);
		    }
		    temp.D= (Transform(transformHeightFromWorld->GetInverse()))(temp.D);
		    oldRefractionPoint= refractionPoint;
		}//end refreaction
	    }//if(refractionPoint.z<heightMin)
	}//if doesnt intersect..
	temp.mint= 0;
    }//end for
    
    temp.mint= 0;
    temp.maxt= FLT_MAX;
    //temp.O already set

    if (prims->Intersect(temp, surf))
	{
	    ray.O= temp.O;
	    ray.D= temp.D;
	    ray.mint= temp.mint;
	    ray.maxt= temp.maxt;
	    	    
	    return true;
	}
    return false;

#else
    return prims->Intersect(ray, surf);
#endif
}






