#ifndef MARTINIGLASS_H
#define MARTINIGLASS_H

#include "shapes.h"

class MartiniGlassContour : public Shape {
  public:
    MartiniGlassContour( const Transform &o2w, Float _height, int _numPoints,
        Float * _contour );
    BBox Bound() const;
    bool Intersect( const Ray &r, DifferentialGeometry *dg ) const;
  private:
    class Strip;
    
    typedef struct {
        Float x;
        Float z;
    } ContourPoint;

    void ConstructStrips( void );
    void ConstructBoundingBoxes( void );

    Float height;
    int numPoints;
    ContourPoint *contour;
    Strip **strip;
    BBox *bbox;
};


class MartiniGlassContour::Strip {
  public:
    Strip( Point & _p1, Point & _p2, Normal & _n1, Normal & _n2 );
    BBox Bound() const;
    bool Intersect( const Ray &r, DifferentialGeometry *dg ) const;
  private:
    Point p1, p2;
    Normal n1, n2;
    Float radius;
    Float height;
    Float apexZ;
    Float zMin, zMax;
    BBox *bbox;
};

#endif
