#ifndef MATERIALS_H
#define MATERIALS_H
#include "lrt.h"
#include "primitives.h"
class Material {
public:
	virtual ~Material() { }
	virtual BSDF *getBSDF(const Surf *surf) const = 0;
	virtual DifferentialGeometry bump(const DifferentialGeometry &dgg) const;
        virtual bool IsVolumetric() const { return false; }
};

class VolumeMaterial : public Material {
  public:
    virtual void SamplePhaseScatter( const Vector &wi, Vector *wo ) const = 0;
    virtual Float PhaseScatter( const Vector & wi, const Vector & wo ) const = 0;
    virtual Float albedo() const = 0;
    virtual Float sigmaT() const = 0;
    virtual Float sigmaS() const = 0;
    virtual Spectrum color() const = 0;
};

class Matte : public Material {
public:
	Matte(Texture<Spectrum> *kd) {
		Kd = kd;
	}
	~Matte();
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd;
};
class Plastic : public Material {
public:
	~Plastic();
	Plastic(Texture<Spectrum> *kd, Texture<Spectrum> *ks,
			Texture<Float> *rough) {
		Kd = kd;
		Ks = ks;
		roughness = rough;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kd, *Ks;
	Texture<Float> *roughness;
};
class Glass : public Material {
public:
	~Glass();
	Glass(Texture<Spectrum> *r, Texture<Spectrum> *t,
			Texture<Float> *i) {
		Kr = r;
		Kt = t;
		index = i;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Kr, *Kt;
	Texture<Float> *index;
};

class FresnelGlass : public Material {
  public:
    FresnelGlass( Spectrum & _color, Texture<Float> *i ) {
        index = i;
        color = _color;
    }
    BSDF *getBSDF( const Surf * surf ) const;
  private:
    Texture<Float> *index;
    Spectrum color;
};

class ShinyMetal : public Material {
public:
	~ShinyMetal();
	ShinyMetal(Texture<Spectrum> *ks, Texture<Float> *rough,
			Texture<Spectrum> *kr) {
		Ks = ks;
		roughness = rough;
		Kr = kr;
	}
	BSDF *getBSDF(const Surf *surf) const;
private:
	Texture<Spectrum> *Ks, *Kr;
	Texture<Float> *roughness;
};

class LiquidInterface : public VolumeMaterial {
  public:
    LiquidInterface( Spectrum & color, Float _indexi, Float _indext, 
        Float _sigS, Float _sigT, Float _k ) {
        _color = color;
        indexi = _indexi;
        indext = _indext;
        _sigmaS = _sigS;
        _sigmaT = _sigT;
        _albedo = _sigmaS / _sigmaT;
        k = _k;
    }
    BSDF * getBSDF( const Surf * surf ) const;
    bool IsVolumetric() const { return true; }
    void SamplePhaseScatter( const Vector &wi, Vector *wo ) const;
    Float PhaseScatter( const Vector & wi, const Vector & wo ) const;
    Float albedo() const { return _albedo; } 
    Float sigmaT() const { return _sigmaT; } 
    Float sigmaS() const { return _sigmaS; }
    Spectrum color() const { return _color; }
  private:
    Spectrum _color;
    Float indexi;
    Float indext;
    Float _sigmaS;
    Float _sigmaT;
    Float _albedo;
    Float k;
};

#endif // MATERIALS_H
