#include "camera.h"

class MbDOFPerspectiveCamera : public Camera {
public:
  MbDOFPerspectiveCamera(const Transform *world2cam, int nTransforms,
			 Float hither, Float yon, 
			 Float shutterOpen, float shutterClose,
			 Float fstop, 
			 Float focalLen, 
			 Float focalDist, 
			 RtToken autoMode, 
                         RtToken meteringMode,
			 Float fov,
			 Film *film);
    ~MbDOFPerspectiveCamera() {};
    bool GenerateRay(Float sample[5], Ray &ray) const;
    void AutoFocus(const Scene *scene);
    void ComputeAutoExposure(const Scene *scene);
private:
    bool CollectLuminance( const Scene *scene, Float sampleX, 
        Float sampleY, Float *lum ); 

    Float Fov;
    Transform WorldToCamera0, WorldToCamera1;
    Transform CameraToWorld0, CameraToWorld1;
    Float ShutterStart, ShutterEnd;
    Float FStop, FocalLength, FocalDistance;
    RtToken Mode;
    RtToken MeteringMode;
};
