
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "fractal.h"

/* Rahul Gupta
 * ===========
 * Simple fractal grid implementation based ont eh Diamond-Square
 * algorithm. 
 *
 */

//static int goof = 0;

Fractal::Fractal(int dimension, bool forBump)
{
  nx = ny = dimension;

  z = (float **) malloc ( sizeof (float *) * dimension);
  for (int t = 0; t < dimension; t++)
    {
      z[t] = (float *) malloc (sizeof(float) * dimension);
    }

  // FIX FIX FIX!!! different for heightfield vs. abalone!!!!! aagha.
  //  if (goof == 1)
  if (!forBump)
    { 
      z[0][0]       = RandHeight(-0.2, 0.6);
      z[0][nx-1]    = RandHeight(-0.2, 0.6);
      z[ny-1][0]    = RandHeight(-0.2, 0.6);
      z[ny-1][nx-1] = RandHeight(-0.2, 0.6);
    }
  else
    {
      z[0][0]       = RandHeight(0.4, 0.8);
      z[0][nx-1]    = RandHeight(0.3, 0.8);
      z[ny-1][0]    = RandHeight(0.2, 0.8);
      z[ny-1][nx-1] = RandHeight(0.3, 0.8);
    }

  // Iteratively cycle through our grid, updating points using the
  // "Diamond-Square" fractal terrain generation method. Since we
  // chose an odd edge-length, we know exactly how many iterations 
  // to complete. 

  int iter = 1;

  float rough;
  if (!forBump)
    {
      rough = RandHeight(0.3, 0.5);
    }
  else
    {
      //      rough = .1;
      rough = RandHeight(0.3, 0.5);
    }

  //  goof++;

  for (int edge = dimension-1; edge > 1; edge/=2)
    {
      // Do the diamond steps.
      for (int yPt = 0; yPt < (ny-1); yPt += edge)
	for (int xPt = 0; xPt < (nx-1); xPt += edge)
	  { 
	    z[yPt + edge/2][xPt + edge/2] = InterpDiamond(xPt, yPt, edge, pow(rough, iter));	    
	  }

      // Do the square steps.
      for (int yPt = 0; yPt < (ny-1); yPt += edge)
	for (int xPt = 0; xPt < (nx-1); xPt += edge)
	  { 
	    InterpSquare(xPt, yPt + edge/2, edge/2, pow(rough, iter));
	    InterpSquare(xPt + edge/2, yPt, edge/2, pow(rough, iter));
	    InterpSquare(xPt + edge, yPt + edge/2, edge/2, pow(rough, iter));
	    InterpSquare(xPt + edge/2, yPt + edge, edge/2, pow(rough, iter));
	  } 

      iter++;
    } 
}

Fractal::~Fractal()
{
  for (int t = 0; t < ny; t++)
    {
      free (z[t]);
    }

  free (z);
}


void Fractal::InterpSquare(int xPt, int yPt, int edge, float rough)
{
  // Will need to change this, eventually . . .
  float noise = RandHeight(-rough, rough);

  float sum = 0;
  int num = 0;

  SquarePt(&sum, &num, xPt + edge, yPt);
  SquarePt(&sum, &num, xPt - edge, yPt);
  SquarePt(&sum, &num, xPt, yPt + edge);
  SquarePt(&sum, &num, xPt, yPt - edge);

  z[yPt][xPt] = (sum/num + noise);
}


void Fractal::SquarePt(float *sum, int *num, int xPt, int yPt)
{
  if ((xPt >= 0) && (xPt < nx) && (yPt >= 0) && (yPt < ny))
    {
      *num += 1;
      *sum += z[yPt][xPt];
    }
}

float Fractal::InterpDiamond(int xPt, int yPt, int edge, float rough)
{
  // Will need to change this, eventually . . .
  float noise = RandHeight(-rough, rough);

  float sum = 0;
  sum += z[yPt][xPt];
  sum += z[yPt][xPt+edge];
  sum += z[yPt+edge][xPt];
  sum += z[yPt + edge][xPt + edge];
  sum /= 4.0;

  return (sum + noise);
}


float Fractal::RandHeight(float lowB, float upB)
{
  return (lowB + (upB - lowB) * (rand() % 100) / 100.0);
}


void Fractal::Transfer(float *heightZ)
{
  for (int t = 0; t < ny; t++)
    {
      memcpy(&heightZ[t * nx], z[t], nx * sizeof(float));
    }
}
