#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"
class Scene {
public:
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts);
	Spectrum L(const Ray &ray) const;
	bool Intersect(const Ray &ray, Surf *surf) const;
	bool IntersectP( const Ray &ray ) const;
	void Render();
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
private:
	PrimitiveSet *prims;
};
#endif // SCENE_H
