#include "mbdofcamera.h"
#include "film.h"
#include <math.h>

Float sqr(Float x)
{
  return x*x;
}

MbDOFPerspectiveCamera::MbDOFPerspectiveCamera(const Transform *world2cam,
		int nTransforms, Float hither, Float yon,
		Float shutterOpen, float shutterClose,
		Float fstop, Float focalLen, Float focalDist,
		RtToken mode, Float fov, Film *film)
	: Camera(world2cam[0],
		Perspective(fov, 1. / 1. /*scene->image->PixelAspectRatio*/,
			hither, yon) * Scale(-1, -1, 1),
		hither, yon, film) {
  
        WorldToCamera0 = world2cam[0];
	if(nTransforms > 1) {
	  WorldToCamera1 = world2cam[1];
	} else {
	  WorldToCamera1 = world2cam[0];
	}

	CameraToWorld0 = WorldToCamera0.GetInverse();
	CameraToWorld1 = WorldToCamera1.GetInverse();

	Point p1 = WorldToCamera0(Point(0,0,0));
	Point p2 = WorldToCamera1(Point(0,0,0));
	
	TravelDistance = sqr(p1.x-p2.x) + sqr(p1.y-p2.y) + sqr(p1.z-p2.z);
	TravelDistance = sqrt(TravelDistance);

	ShutterStart = shutterOpen;
	ShutterEnd = shutterClose;
	FStop = fstop;
	FocalLength = focalLen;
	FocalDistance = focalDist;
	Mode = mode;
	MyFilm = film;
	cerr << "Camera Mode=" << Mode << endl;
	if(Mode==LRT_MANUAL)
	  {
	    printf("manual\n");
	    SetGain();
	  }
}

Float MbDOFPerspectiveCamera::GetDistanceMoved()
{
  return TravelDistance;
}

void MbDOFPerspectiveCamera::SetGain()
{
  MyFilm->image->Gain *= ShutterEnd/(FStop*FStop); 
}

bool MbDOFPerspectiveCamera::GenerateRay(Float sample[5], Ray &ray) const
{
  if (sample[0] < film->GetImage()->SampleCropLeft ||
      sample[0] > film->GetImage()->SampleCropRight ||
      sample[1] < film->GetImage()->SampleCropBottom ||
      sample[1] > film->GetImage()->SampleCropTop)
    return false;

  Float lensRadius;
  Float ratio;

  Point nearClip = RasterToCamera(Point(sample[0],sample[1],0));

  if (FStop == RI_INFINITY)
    {
      lensRadius = 0;
      ratio = 1;
    }
  else
    {
      lensRadius = (FocalLength/FStop)/2.0;
      ratio = FocalDistance / nearClip.z;
    }

  Point pCamera = Point(nearClip.x*ratio, nearClip.y*ratio,
			nearClip.z*ratio);
  Point lensPoint = Point(cos(sample[2]*2*M_PI)*sample[3]*lensRadius,
			  sin(sample[2]*2*M_PI)*sample[3]*lensRadius, 0);

  Vector dVector=Vector(pCamera.x, pCamera.y, pCamera.z);
  dVector-=Vector(lensPoint.x, lensPoint.y, lensPoint.z);
				   
  dVector.Normalize();

  ray = Ray(lensPoint, dVector);
  // printf("%g\n", ShutterEnd);

  Point point1 = CameraToWorld0(Point(0,0,0));
  Point point2 = CameraToWorld1(Point(0,0,0));

  //cap ShutterEnd at 1

  Float realShutter = (ShutterEnd>1)?1:ShutterEnd;
  Transform InterpCtoW =
  Translate(Vector(point1.x*(1-sample[4]*realShutter)+
		   point2.x*(sample[4]*realShutter),
		   point1.y*(1-sample[4]*realShutter)+
		   point2.y*(sample[4]*realShutter),
		   point1.z*(1-sample[4]*realShutter)+
		   point2.z*(sample[4]*realShutter)));

  ray = InterpCtoW(ray);

  return true;
}
