#ifndef MB_CAM_
#define MB_CAM_

#include "camera.h"

class MbDOFPerspectiveCamera : public Camera {
public:
  MbDOFPerspectiveCamera(const Transform *world2cam, int nTransforms,
			 Float hither, Float yon, 
			 Float shutterOpen, float shutterClose,
			 Float fstop, 
			 Float focalLen, 
			 Float focalDist, 
			 RtToken mode, 
			 Float fov,
			 Film *film);
	~MbDOFPerspectiveCamera() {};
	bool GenerateRay(Float sample[5], Ray &ray) const;
	bool IsAutomatic() const {
	  return (Mode==LRT_PROGRAMMED ||
		  Mode==LRT_SHUTTER_PRIORITY ||
		  Mode==LRT_APERTURE_PRIORITY);}

	void SetFStop(Float fstop) {FStop = fstop;}
	void SetFocalDistance(Float focalDist) {FocalDistance = focalDist;}
	void SetShutterEnd(Float shutterEnd) {ShutterEnd = shutterEnd;}
	void SetGain();
	Float GetFStop() {return FStop;}
	Float GetShutterEnd() {return ShutterEnd;}
	RtToken GetMode() {return Mode;}
	Float GetDistanceMoved();

private:
	Transform WorldToCamera0, WorldToCamera1;
	Transform CameraToWorld0, CameraToWorld1;
	Float ShutterStart, ShutterEnd;
	Float FStop, FocalLength, FocalDistance;
	Float TravelDistance;
	Film* MyFilm;
	RtToken Mode;
};
#endif
