
/*  A Bison parser, made from work/ribparse.y
 by  GNU Bison version 1.25
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	STRING	258
#define	ID	259
#define	NUM	260
#define	LBRACK	261
#define	RBRACK	262
#define	DASH	263
#define	AREALIGHTSOURCE	264
#define	ATMOSPHERE	265
#define	ATTRIBUTE	266
#define	ATTRIBUTEBEGIN	267
#define	ATTRIBUTEEND	268
#define	BASIS	269
#define	BOUND	270
#define	CLIPPING	271
#define	COLOR	272
#define	COLORSAMPLES	273
#define	CONCATTRANSFORM	274
#define	CONE	275
#define	COORDINATESYSTEM	276
#define	CROPWINDOW	277
#define	CYLINDER	278
#define	DECLARE	279
#define	DEFORMATION	280
#define	DEPTHOFFIELD	281
#define	DETAIL	282
#define	DETAILRANGE	283
#define	DISK	284
#define	DISPLACEMENT	285
#define	DISPLAY	286
#define	EXPOSURE	287
#define	EXTERIOR	288
#define	FORMAT	289
#define	FRAMEASPECTRATIO	290
#define	FRAMEBEGIN	291
#define	FRAMEEND	292
#define	GENERALPOLYGON	293
#define	GEOMETRICAPPROXIMATION	294
#define	GEOMETRY	295
#define	HIDER	296
#define	HYPERBOLOID	297
#define	IDENTITY	298
#define	ILLUMINATE	299
#define	IMAGER	300
#define	INTERIOR	301
#define	LIGHTSOURCE	302
#define	MAKEBUMP	303
#define	MAKECUBEFACEENVIRONMENT	304
#define	MAKELATLONGENVIRONMENT	305
#define	MAKESHADOW	306
#define	MAKETEXTURE	307
#define	MATTE	308
#define	MOTIONBEGIN	309
#define	MOTIONEND	310
#define	NUPATCH	311
#define	OBJECTBEGIN	312
#define	OBJECTEND	313
#define	OBJECTINSTANCE	314
#define	OPACITY	315
#define	OPTION	316
#define	ORIENTATION	317
#define	PARABOLOID	318
#define	PATCH	319
#define	PATCHMESH	320
#define	PERSPECTIVE	321
#define	PIXELFILTER	322
#define	PIXELSAMPLES	323
#define	PIXELVARIANCE	324
#define	POINTSGENERALPOLYGONS	325
#define	POINTSPOLYGONS	326
#define	POLYGON	327
#define	PROJECTION	328
#define	QUANTIZE	329
#define	RELATIVEDETAIL	330
#define	REVERSEORIENTATION	331
#define	ROTATE	332
#define	SCALE	333
#define	SCREENWINDOW	334
#define	SHADINGINTERPOLATION	335
#define	SHADINGRATE	336
#define	SHUTTER	337
#define	SIDES	338
#define	SKEW	339
#define	SOLIDBEGIN	340
#define	SOLIDEND	341
#define	SPHERE	342
#define	SURFACE	343
#define	TEXTURECOORDINATES	344
#define	TORUS	345
#define	TRANSFORM	346
#define	TRANSFORMBEGIN	347
#define	TRANSFORMEND	348
#define	TRANSLATE	349
#define	TRIMCURVE	350
#define	VERSION	351
#define	WORLDBEGIN	352
#define	WORLDEND	353
#define	HIGH_PRECEDENCE	354

#line 1 "work/ribparse.y"

#include "ri.h"
#include "lrt.h"

#include <stdarg.h>

extern int yylex( void );
int line_num = 1;

#define YYMAXDEPTH 100000000

void yyerror( char *str ) {
	Error( "RIB parsing error on line %d\n\t%s", line_num,str );
}

void ParseError( const char *format, ... ) PRINTF_FORMAT;

void ParseError( const char *format, ... ) {
	char error[4096];
	va_list args;
	va_start( args, format );
	vsprintf( error, format, args );
	yyerror(error);
	va_end( args );
}

// RI says 64k is the maxiumum light handle number
#define MAX_LIGHT_HANDLE 65536
static RtLightHandle lights[MAX_LIGHT_HANDLE];

int cur_paramlist_allocated = 0;
int cur_paramlist_size = 0;
RtToken *cur_paramlist_tokens = NULL;
RtPointer *cur_paramlist_args = NULL;
RtInt *cur_paramlist_sizes = NULL;

#define CPS cur_paramlist_size
#define CPT cur_paramlist_tokens
#define CPA cur_paramlist_args
#define CPSZ cur_paramlist_sizes

typedef struct RIB_array {
	int element_size;
	int allocated;
	int nelems;
	RtVoid *array;
} RIB_array;

RIB_array *cur_array = NULL;

#define NA(r) ((RtFloat *) r->array)
#define SA(r) ((const char **) r->array)

void AddArrayElement( void *elem ) {
	if (cur_array->nelems >= cur_array->allocated) {
		cur_array->allocated = 2*cur_array->allocated + 1;
		cur_array->array = realloc( cur_array->array,
			cur_array->allocated*cur_array->element_size );
	}
	char *next = ((char *)cur_array->array) + cur_array->nelems *
		cur_array->element_size;
	memcpy( next, elem, cur_array->element_size );
	cur_array->nelems++;
}

RIB_array *ArrayDup( RIB_array *ra )
{
	RIB_array *ret = new RIB_array;
	ret->element_size = ra->element_size;
	ret->allocated = ra->allocated;
	ret->nelems = ra->nelems;
	ret->array = new char[ra->nelems * ra->element_size];
	memcpy( ret->array, ra->array, ra->nelems * ra->element_size );
	return ret;
}

void ArrayFree( RIB_array *ra )
{
	delete [] ((char *) ra->array);
	delete ra;
}

static RtFloat * FindBasis( const char *str )
{
	/*
	if (!strcmp( str, "bezier" )) return (RtFloat *) RiBezierBasis;
	else if (!strcmp( str, "b-spline" )) return (RtFloat *) RiBSplineBasis;
	else if (!strcmp( str, "catmull-rom" )) return (RtFloat *) RiCatmullRomBasis;
	else if (!strcmp( str, "hermite" )) return (RtFloat *) RiHermiteBasis;
	else if (!strcmp( str, "power" )) return (RtFloat *) RiPowerBasis;
	else ParseError( "Unknown basis: %s", str );
	*/

	Warning("Named bases aren't supported yet...");

	return NULL;
}
static bool VerifyArrayLength( RIB_array *arr, RtInt required,
	const char *command ) {
	if (arr->nelems != required) {
		ParseError( "%s requires a(n) %d element array!", command, required);
		return false;
	}
	return true;
}

static RtInt *MakeIntArray( RIB_array *arr )
{
	RtInt *ret = new RtInt[arr->nelems];
	for (int i = 0 ; i < arr->nelems ; i++)
		ret[i] = RtInt(NA(arr)[i]);
	return ret;
}

static RtFilterFunc FindFilterFunc( const char *name )
{
	if (!strcmp( name, "box" ))
		return RiBoxFilter;
	else if (!strcmp( name, "triangle" ))
		return RiTriangleFilter;
	else if (!strcmp( name, "catmull-rom" ))
		return RiCatmullRomFilter;
	else if (!strcmp( name, "sinc" ))
		return RiSincFilter;
	else if (!strcmp( name, "gaussian" ))
		return RiGaussianFilter;
	else
		ParseError( "Unknown filter function :%s", name );
	return RtFilterFunc(NULL);
}

#line 133 "work/ribparse.y"
typedef union {
char string[1024];
RtFloat num;
RIB_array *ribarray;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		412
#define	YYFLAG		-32768
#define	YYNTBASE	100

#define YYTRANSLATE(x) ((unsigned)(x) <= 354 ? yytranslate[x] : 121)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
    46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
    56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
    76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
    86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
    96,    97,    98,    99
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     4,     5,     7,     9,    11,    13,    18,
    21,    24,    26,    29,    31,    33,    38,    41,    44,    46,
    49,    52,    53,    56,    57,    60,    63,    65,    68,    73,
    77,    81,    83,    85,    91,    97,   103,   109,   117,   120,
   124,   129,   132,   136,   142,   146,   149,   152,   158,   161,
   168,   172,   176,   180,   185,   188,   196,   199,   205,   208,
   214,   218,   222,   228,   232,   236,   241,   244,   247,   249,
   253,   257,   261,   265,   275,   279,   281,   285,   289,   293,
   298,   308,   322,   330,   335,   345,   348,   351,   353,   366,
   369,   371,   374,   379,   382,   386,   389,   396,   400,   404,
   412,   415,   420,   424,   427,   433,   438,   441,   445,   452,
   455,   457,   463,   468,   474,   477,   480,   483,   487,   490,
   499,   502,   505,   507,   514,   518,   522,   532,   535,   543,
   547,   550,   552,   554,   559,   570,   572
};

static const short yyrhs[] = {   119,
     0,     0,     0,     0,   105,     0,   110,     0,   106,     0,
   107,     0,   101,     6,   108,     7,     0,   101,   109,     0,
   108,   109,     0,   109,     0,   102,     3,     0,   111,     0,
   112,     0,   101,     6,   113,     7,     0,   101,   114,     0,
   113,   114,     0,   114,     0,   103,     5,     0,   116,   117,
     0,     0,   118,   117,     0,     0,     3,   104,     0,   119,
   120,     0,   120,     0,    96,     5,     0,     9,     3,     5,
   115,     0,    10,     3,   115,     0,    11,     3,   115,     0,
    12,     0,    13,     0,    14,     3,     5,     3,     5,     0,
    14,     3,     5,   111,     5,     0,    14,   111,     5,     3,
     5,     0,    14,   111,     5,   111,     5,     0,    15,     5,
     5,     5,     5,     5,     5,     0,    15,   111,     0,    16,
     5,     5,     0,    17,     5,     5,     5,     0,    17,   111,
     0,    18,   111,   111,     0,    20,     5,     5,     5,   115,
     0,    20,   111,   115,     0,    19,   110,     0,    21,     3,
     0,    22,     5,     5,     5,     5,     0,    22,   111,     0,
    23,     5,     5,     5,     5,   115,     0,    23,   111,   115,
     0,    24,     3,     3,     0,    25,     3,   115,     0,    26,
     5,     5,     5,     0,    26,     8,     0,    27,     5,     5,
     5,     5,     5,     5,     0,    27,   111,     0,    28,     5,
     5,     5,     5,     0,    28,   111,     0,    29,     5,     5,
     5,   115,     0,    29,   111,   115,     0,    30,     3,   115,
     0,    31,     3,     3,     3,   115,     0,    32,     5,     5,
     0,    33,     3,   115,     0,    34,     5,     5,     5,     0,
    35,     5,     0,    36,     5,     0,    37,     0,    38,   110,
   115,     0,    39,     3,     5,     0,    40,     3,   115,     0,
    41,     3,   115,     0,    42,     5,     5,     5,     5,     5,
     5,     5,   115,     0,    42,   111,   115,     0,    43,     0,
    44,     5,     5,     0,    45,     3,   115,     0,    46,     3,
   115,     0,    47,     3,     5,   115,     0,    48,     3,     3,
     3,     3,     3,     5,     5,   115,     0,    49,     3,     3,
     3,     3,     3,     3,     3,     5,     3,     5,     5,   115,
     0,    50,     3,     3,     3,     5,     5,   115,     0,    51,
     3,     3,   115,     0,    52,     3,     3,     3,     3,     3,
     5,     5,   115,     0,    53,     5,     0,    54,   110,     0,
    55,     0,    56,     5,     5,   111,     5,     5,     5,     5,
   111,     5,     5,   115,     0,    57,     5,     0,    58,     0,
    59,     5,     0,    60,     5,     5,     5,     0,    60,   111,
     0,    61,     3,   115,     0,    62,     3,     0,    63,     5,
     5,     5,     5,   115,     0,    63,   111,   115,     0,    64,
     3,   115,     0,    65,     3,     5,     3,     5,     3,   115,
     0,    66,     5,     0,    67,     3,     5,     5,     0,    68,
     5,     5,     0,    69,     5,     0,    70,   110,   110,   110,
   115,     0,    71,   110,   110,   115,     0,    72,   115,     0,
    73,     3,   115,     0,    74,     3,     5,     5,     5,     5,
     0,    75,     5,     0,    76,     0,    77,     5,     5,     5,
     5,     0,    78,     5,     5,     5,     0,    79,     5,     5,
     5,     5,     0,    79,   111,     0,    80,     3,     0,    81,
     5,     0,    82,     5,     5,     0,    83,     5,     0,    84,
     5,     5,     5,     5,     5,     5,     5,     0,    84,   111,
     0,    85,     3,     0,    86,     0,    87,     5,     5,     5,
     5,   115,     0,    87,   111,   115,     0,    88,     3,   115,
     0,    89,     5,     5,     5,     5,     5,     5,     5,     5,
     0,    89,   111,     0,    90,     5,     5,     5,     5,     5,
   115,     0,    90,   111,   115,     0,    91,   111,     0,    92,
     0,    93,     0,    94,     5,     5,     5,     0,    95,   110,
   110,   110,   110,   110,   110,   110,   110,   110,     0,    97,
     0,    98,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   169,   171,   180,   185,   190,   194,   199,   203,   208,   212,
   214,   215,   217,   223,   227,   232,   236,   238,   239,   241,
   247,   249,   254,   255,   257,   273,   274,   276,   277,   285,
   289,   293,   297,   301,   307,   315,   323,   330,   337,   343,
   347,   353,   359,   374,   378,   383,   389,   393,   397,   403,
   407,   413,   417,   421,   425,   429,   436,   442,   446,   452,
   456,   462,   466,   470,   474,   478,   482,   486,   490,   494,
   501,   505,   509,   513,   520,   530,   534,   547,   551,   555,
   563,   568,   574,   579,   583,   588,   592,   597,   601,   608,
   612,   616,   620,   626,   632,   636,   640,   644,   650,   654,
   658,   662,   667,   671,   675,   692,   712,   734,   738,   742,
   746,   750,   754,   758,   762,   768,   772,   776,   780,   784,
   788,   795,   799,   803,   807,   813,   817,   822,   829,   833,
   840,   846,   850,   854,   858,   881,   885
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","STRING",
"ID","NUM","LBRACK","RBRACK","DASH","AREALIGHTSOURCE","ATMOSPHERE","ATTRIBUTE",
"ATTRIBUTEBEGIN","ATTRIBUTEEND","BASIS","BOUND","CLIPPING","COLOR","COLORSAMPLES",
"CONCATTRANSFORM","CONE","COORDINATESYSTEM","CROPWINDOW","CYLINDER","DECLARE",
"DEFORMATION","DEPTHOFFIELD","DETAIL","DETAILRANGE","DISK","DISPLACEMENT","DISPLAY",
"EXPOSURE","EXTERIOR","FORMAT","FRAMEASPECTRATIO","FRAMEBEGIN","FRAMEEND","GENERALPOLYGON",
"GEOMETRICAPPROXIMATION","GEOMETRY","HIDER","HYPERBOLOID","IDENTITY","ILLUMINATE",
"IMAGER","INTERIOR","LIGHTSOURCE","MAKEBUMP","MAKECUBEFACEENVIRONMENT","MAKELATLONGENVIRONMENT",
"MAKESHADOW","MAKETEXTURE","MATTE","MOTIONBEGIN","MOTIONEND","NUPATCH","OBJECTBEGIN",
"OBJECTEND","OBJECTINSTANCE","OPACITY","OPTION","ORIENTATION","PARABOLOID","PATCH",
"PATCHMESH","PERSPECTIVE","PIXELFILTER","PIXELSAMPLES","PIXELVARIANCE","POINTSGENERALPOLYGONS",
"POINTSPOLYGONS","POLYGON","PROJECTION","QUANTIZE","RELATIVEDETAIL","REVERSEORIENTATION",
"ROTATE","SCALE","SCREENWINDOW","SHADINGINTERPOLATION","SHADINGRATE","SHUTTER",
"SIDES","SKEW","SOLIDBEGIN","SOLIDEND","SPHERE","SURFACE","TEXTURECOORDINATES",
"TORUS","TRANSFORM","TRANSFORMBEGIN","TRANSFORMEND","TRANSLATE","TRIMCURVE",
"VERSION","WORLDBEGIN","WORLDEND","HIGH_PRECEDENCE","start","array_init","string_array_init",
"num_array_init","array","string_array","real_string_array","single_element_string_array",
"string_list","string_list_entry","num_array","real_num_array","single_element_num_array",
"num_list","num_list_entry","paramlist","paramlist_init","paramlist_contents",
"paramlist_entry","ri_stmt_list","ri_stmt", NULL
};
#endif

static const short yyr1[] = {     0,
   100,   101,   102,   103,   104,   104,   105,   105,   106,   107,
   108,   108,   109,   110,   110,   111,   112,   113,   113,   114,
   115,   116,   117,   117,   118,   119,   119,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120,   120,   120,   120,
   120,   120,   120,   120,   120,   120,   120
};

static const short yyr2[] = {     0,
     1,     0,     0,     0,     1,     1,     1,     1,     4,     2,
     2,     1,     2,     1,     1,     4,     2,     2,     1,     2,
     2,     0,     2,     0,     2,     2,     1,     2,     4,     3,
     3,     1,     1,     5,     5,     5,     5,     7,     2,     3,
     4,     2,     3,     5,     3,     2,     2,     5,     2,     6,
     3,     3,     3,     4,     2,     7,     2,     5,     2,     5,
     3,     3,     5,     3,     3,     4,     2,     2,     1,     3,
     3,     3,     3,     9,     3,     1,     3,     3,     3,     4,
     9,    13,     7,     4,     9,     2,     2,     1,    12,     2,
     1,     2,     4,     2,     3,     2,     6,     3,     3,     7,
     2,     4,     3,     2,     5,     4,     2,     3,     6,     2,
     1,     5,     4,     5,     2,     2,     2,     3,     2,     8,
     2,     2,     1,     6,     3,     3,     9,     2,     7,     3,
     2,     1,     1,     4,    10,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,    32,    33,     2,     2,     0,     2,     2,
     2,     2,     0,     2,     2,     0,     0,     0,     2,     2,
     2,     0,     0,     0,     0,     0,     0,     0,    69,     2,
     0,     0,     0,     2,    76,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     2,    88,     0,     0,    91,
     0,     2,     0,     0,     2,     0,     0,     0,     0,     0,
     0,     2,     2,    22,     0,     0,     0,   111,     0,     0,
     2,     0,     0,     0,     0,     2,     0,   123,     2,     0,
     2,     2,     2,   132,   133,     0,     2,     0,   136,   137,
     1,    27,     0,    22,    22,     0,     0,     0,     0,    39,
     0,     0,    42,     2,     4,    46,    14,    15,     0,    22,
    47,     0,    49,     0,    22,     0,    22,     0,    55,     0,
    57,     0,    59,     0,    22,    22,     0,     0,    22,     0,
    67,    68,    22,     0,    22,    22,     0,    22,     0,    22,
    22,     0,     0,     0,     0,     0,     0,    86,    87,     0,
    90,    92,     0,    94,    22,    96,     0,    22,    22,     0,
   101,     0,     0,   104,     2,     2,   107,    24,    22,     0,
   110,     0,     0,     0,   115,   116,   117,     0,   119,     0,
   121,   122,     0,    22,    22,     0,   128,     0,    22,   131,
     0,     2,    28,    26,    22,    30,    31,     2,     4,     2,
     0,    40,     0,    43,     0,    17,     0,    45,     0,     0,
    51,    52,    53,     0,     0,     0,     0,    61,    62,     0,
    64,    65,     0,    70,    71,    72,    73,     0,    75,    77,
    78,    79,    22,     0,     0,     0,    22,     0,     2,     0,
    95,     0,    98,    99,     0,     0,   103,     2,    22,     2,
    21,    24,   108,     0,     0,     0,     0,   118,     0,     0,
   125,   126,     0,     0,   130,     0,     2,    29,     0,     0,
     4,    19,     0,     0,     0,    41,    20,    22,     0,     0,
    54,     0,     0,    22,    22,    66,     0,    80,     0,     0,
     0,    84,     0,     0,    93,     0,     0,   102,    22,   106,
     3,    25,     5,     7,     8,     6,    23,     0,     0,   113,
     0,     0,     0,     0,     0,   134,     2,    34,    35,    16,
    18,    36,    37,     0,    44,    48,    22,     0,    58,    60,
    63,     0,     0,     0,     0,     0,     0,    22,     0,   105,
     3,     0,    10,     0,   112,   114,     0,    22,     0,     0,
     2,     0,    50,     0,     0,     0,     0,    22,     0,     0,
    97,    22,     3,    12,    13,   109,     0,   124,     0,    22,
     2,    38,    56,     0,     0,     0,    83,     0,     0,   100,
     9,    11,     0,     0,   129,     2,    22,    22,     0,    22,
     2,   120,     0,     2,    74,    81,     0,    85,     0,   127,
     2,     0,     0,   135,     0,    22,    22,    89,    82,     0,
     0,     0
};

static const short yydefgoto[] = {   410,
    97,   342,   205,   302,   303,   304,   305,   363,   343,   106,
   107,   108,   271,   206,   167,   168,   251,   252,    91,    92
};

static const short yypact[] = {   400,
     4,    10,    12,-32768,-32768,    15,    19,    22,    23,-32768,
-32768,    24,    17,    25,    26,    29,    30,    -4,    32,    33,
    34,    31,    37,    36,    41,    40,    42,    43,-32768,-32768,
    46,    47,    50,    51,-32768,    53,    52,    56,    57,    58,
    59,    60,    61,    62,    63,-32768,-32768,    64,    65,-32768,
    66,    67,    72,    74,    75,    76,    79,    81,    84,    83,
    85,-32768,-32768,-32768,    86,    88,    87,-32768,    89,    92,
    93,    90,    94,    95,    96,    97,   100,-32768,    99,   102,
   103,   104,-32768,-32768,-32768,   105,-32768,   107,-32768,-32768,
   400,-32768,   108,-32768,-32768,   109,   101,   110,   112,-32768,
   114,   115,-32768,-32768,   101,-32768,-32768,-32768,   116,-32768,
-32768,   117,-32768,   118,-32768,   121,-32768,   120,-32768,   123,
-32768,   124,-32768,   126,-32768,-32768,   129,   128,-32768,   130,
-32768,-32768,-32768,   133,-32768,-32768,   135,-32768,   138,-32768,
-32768,   142,   145,   146,   147,   148,   149,-32768,-32768,   152,
-32768,-32768,   153,-32768,-32768,-32768,   156,-32768,-32768,   157,
-32768,   158,   159,-32768,-32768,-32768,-32768,   150,-32768,   160,
-32768,   161,   162,   163,-32768,-32768,-32768,   164,-32768,   166,
-32768,-32768,   168,-32768,-32768,   169,-32768,   170,-32768,-32768,
   171,-32768,-32768,-32768,-32768,-32768,-32768,   174,-32768,   175,
   177,-32768,   178,-32768,   179,-32768,   182,-32768,   183,   184,
-32768,-32768,-32768,   186,   187,   188,   189,-32768,-32768,   176,
-32768,-32768,   190,-32768,-32768,-32768,-32768,   192,-32768,-32768,
-32768,-32768,-32768,   195,   196,   198,-32768,   200,-32768,   199,
-32768,   201,-32768,-32768,   202,   203,-32768,-32768,-32768,-32768,
-32768,   150,-32768,   204,   205,   206,   207,-32768,   208,   209,
-32768,-32768,   210,   211,-32768,   212,-32768,-32768,   213,   214,
    39,-32768,   215,   216,   217,-32768,-32768,-32768,   218,   219,
-32768,   220,   221,-32768,-32768,-32768,   222,-32768,   226,   228,
   227,-32768,   230,   231,-32768,   235,   237,-32768,-32768,-32768,
     0,-32768,-32768,-32768,-32768,-32768,-32768,   238,   239,-32768,
   240,   241,   243,   244,   246,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,   247,-32768,-32768,-32768,   248,-32768,-32768,
-32768,   249,   232,   252,   253,   254,   255,-32768,   256,-32768,
   257,   258,-32768,   259,-32768,-32768,   260,-32768,   261,   262,
-32768,   263,-32768,   264,   265,   266,   269,-32768,   268,   270,
-32768,-32768,   173,-32768,-32768,-32768,   271,-32768,   272,-32768,
-32768,-32768,-32768,   273,   275,   278,-32768,   277,   279,-32768,
-32768,-32768,   282,   283,-32768,-32768,-32768,-32768,   284,-32768,
-32768,-32768,   285,-32768,-32768,-32768,   280,-32768,   286,-32768,
-32768,   287,   288,-32768,   289,-32768,-32768,-32768,-32768,   274,
   295,-32768
};

static const short yypgoto[] = {-32768,
   -11,-32768,-32768,-32768,-32768,-32768,-32768,-32768,  -338,   -20,
     2,-32768,-32768,  -197,     1,-32768,  -186,-32768,-32768,   172
};


#define	YYLAST		498


static const short yytable[] = {   105,
   118,   272,   364,   119,    -4,   341,    93,    98,   100,   133,
   103,   104,    94,   110,    95,   113,   115,    96,   105,   111,
   121,   123,   125,    99,   382,   149,   101,   102,   109,   112,
   114,   116,   117,   126,   105,   138,   120,   122,   124,   127,
   128,   165,   166,   129,   130,   320,   131,   132,   134,   135,
   105,   105,   136,   154,   140,   137,   158,   139,   141,   142,
   143,   144,   145,   146,   147,   307,   192,   148,   150,   151,
   152,   153,   175,   321,   155,   105,   156,   181,   159,   157,
   184,   160,   187,   189,   190,   161,   162,   163,   169,   164,
   170,   171,   176,   172,   196,   197,   173,   174,   177,   178,
   179,   180,   182,   183,   185,   204,   199,   186,   188,   191,
   208,   193,   195,   198,   200,   211,   201,   213,   202,   203,
   207,   209,   210,   212,   214,   218,   219,   215,   216,   222,
   217,   220,   221,   224,   223,   226,   227,   225,   229,   228,
   231,   232,   230,   272,   248,   249,   233,   234,   235,   236,
   237,   238,   250,   105,   105,   241,   239,   240,   243,   244,
   242,   245,   246,   247,   254,   255,   256,   257,   258,   253,
   259,   267,   260,   263,   264,   266,   269,   273,   285,   381,
   105,   275,   276,   277,   261,   262,   278,   279,   280,   265,
   281,   282,   283,   284,   286,   268,   287,   289,   290,   270,
   291,   274,   293,   295,   297,   296,     0,   298,   308,   309,
   310,   311,   312,   313,   314,   315,   316,   318,   319,   322,
   323,   324,   326,   327,   328,   329,   332,   299,   333,   306,
   334,   335,   336,   288,   356,   337,   105,   292,   301,   338,
   294,   339,   344,   345,   346,   347,   317,   348,   349,   300,
   350,   352,   354,   355,   357,   105,   359,   358,   362,   360,
   365,    -4,   194,   366,   367,   369,   370,   372,   373,   374,
   375,   376,   378,   411,   379,   383,   384,   387,   325,   388,
   389,   390,   402,   391,   330,   331,   392,   393,   397,   400,
   403,   405,   406,   407,   412,     0,   351,     0,     0,   340,
     0,     0,     0,     0,     0,   105,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,   353,     0,     0,
   371,     0,     0,     0,     0,     0,     0,     0,   361,   105,
     0,     0,     0,     0,     0,     0,     0,     0,   368,     0,
   386,     0,     0,     0,     0,     0,     0,     0,   377,   105,
     0,     0,   380,     0,     0,   394,     0,     0,     0,     0,
   385,     0,     0,   401,   105,     0,     0,     0,     0,     0,
   404,     0,   105,     0,     0,     0,     0,   395,   396,   105,
   398,     0,   399,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   408,   409,     1,     2,
     3,     4,     5,     6,     7,     8,     9,    10,    11,    12,
    13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
    23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
    33,    34,    35,    36,    37,    38,    39,    40,    41,    42,
    43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
    53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
    63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
    73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
    83,    84,    85,    86,    87,    88,    89,    90
};

static const short yycheck[] = {    11,
     5,   199,   341,     8,     5,     6,     3,     6,     7,    30,
     9,    10,     3,    12,     3,    14,    15,     3,    30,     3,
    19,    20,    21,     5,   363,    46,     5,     5,     5,     5,
     5,     3,     3,     3,    46,    34,     5,     5,     5,     3,
     5,    62,    63,     3,     5,     7,     5,     5,     3,     3,
    62,    63,     3,    52,     3,     5,    55,     5,     3,     3,
     3,     3,     3,     3,     3,   252,    87,     5,     5,     5,
     5,     5,    71,   271,     3,    87,     3,    76,     3,     5,
    79,     3,    81,    82,    83,     5,     3,     5,     3,     5,
     3,     5,     3,     5,    94,    95,     5,     5,     5,     5,
     5,     5,     3,     5,     3,   104,     6,     5,     5,     5,
   110,     5,     5,     5,     5,   115,     5,   117,     5,     5,
     5,     5,     5,     3,     5,   125,   126,     5,     5,   129,
     5,     3,     5,   133,     5,   135,   136,     5,   138,     5,
   140,   141,     5,   341,   165,   166,     5,     3,     3,     3,
     3,     3,     3,   165,   166,   155,     5,     5,   158,   159,
     5,     5,     5,     5,     5,     5,     5,     5,     5,   169,
     5,   192,     5,     5,     5,     5,     3,     3,     3,     7,
   192,     5,     5,     5,   184,   185,     5,     5,     5,   189,
     5,     5,     5,     5,     5,   195,     5,     3,     3,   198,
     3,   200,     3,     5,     3,     5,    -1,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     5,     5,   248,     3,   250,
     3,     5,     3,   233,     3,     5,   248,   237,   250,     5,
   239,     5,     5,     5,     5,     5,   267,     5,     5,   249,
     5,     5,     5,     5,     3,   267,     3,     5,     3,     5,
     3,     5,    91,     5,     5,     5,     5,     5,     5,     5,
     5,     3,     5,     0,     5,     5,     5,     5,   278,     5,
     3,     5,     3,     5,   284,   285,     5,     5,     5,     5,
     5,     5,     5,     5,     0,    -1,   317,    -1,    -1,   299,
    -1,    -1,    -1,    -1,    -1,   317,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,   327,    -1,    -1,
   351,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   338,   351,
    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   348,    -1,
   371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   358,   371,
    -1,    -1,   362,    -1,    -1,   386,    -1,    -1,    -1,    -1,
   370,    -1,    -1,   394,   386,    -1,    -1,    -1,    -1,    -1,
   401,    -1,   394,    -1,    -1,    -1,    -1,   387,   388,   401,
   390,    -1,   391,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    -1,   406,   407,     9,    10,
    11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
    21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
    31,    32,    33,    34,    35,    36,    37,    38,    39,    40,
    41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
    51,    52,    53,    54,    55,    56,    57,    58,    59,    60,
    61,    62,    63,    64,    65,    66,    67,    68,    69,    70,
    71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
    81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
    91,    92,    93,    94,    95,    96,    97,    98
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/common/share/bison.simple"

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

#ifndef alloca
#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi)
#include <alloca.h>
#else /* not sparc */
#if defined (MSDOS) && !defined (__TURBOC__)
#include <malloc.h>
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
#include <malloc.h>
 #pragma alloca
#else /* not MSDOS, __TURBOC__, or _AIX */
#ifdef __hpux
#ifdef __cplusplus
extern "C" {
void *alloca (unsigned int);
};
#else /* not __cplusplus */
void *alloca ();
#endif /* not __cplusplus */
#endif /* __hpux */
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc.  */
#endif /* not GNU C.  */
#endif /* alloca not defined.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	return(0)
#define YYABORT 	return(1)
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
int yyparse (void);
#endif

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, int count)
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 196 "/usr/common/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 172 "work/ribparse.y"
{
	if (cur_array) ArrayFree( cur_array );
	cur_array = new RIB_array;
	cur_array->allocated = 0;
	cur_array->nelems = 0;
	cur_array->array = NULL;
;
    break;}
case 3:
#line 181 "work/ribparse.y"
{
	cur_array->element_size = sizeof( const char * );
;
    break;}
case 4:
#line 186 "work/ribparse.y"
{
	cur_array->element_size = sizeof( RtFloat );
;
    break;}
case 5:
#line 191 "work/ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 6:
#line 195 "work/ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 7:
#line 200 "work/ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 8:
#line 204 "work/ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 9:
#line 209 "work/ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 13:
#line 218 "work/ribparse.y"
{
	char *to_add = strdup(yyvsp[0].string);
	AddArrayElement( &to_add );
;
    break;}
case 14:
#line 224 "work/ribparse.y"
{
	yyval.ribarray = yyvsp[0].ribarray;
;
    break;}
case 15:
#line 228 "work/ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 16:
#line 233 "work/ribparse.y"
{
	yyval.ribarray = ArrayDup(cur_array);
;
    break;}
case 20:
#line 242 "work/ribparse.y"
{
	RtFloat to_add = yyvsp[0].num;
	AddArrayElement( &to_add );
;
    break;}
case 22:
#line 250 "work/ribparse.y"
{
	cur_paramlist_size = 0;
;
    break;}
case 25:
#line 258 "work/ribparse.y"
{
	RtPointer arg = new char[ yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size ];
	memcpy( arg, yyvsp[0].ribarray->array, yyvsp[0].ribarray->nelems * yyvsp[0].ribarray->element_size );
	if (cur_paramlist_size >= cur_paramlist_allocated) {
		cur_paramlist_allocated = 2*cur_paramlist_allocated + 1;
		cur_paramlist_tokens = (RtToken *) realloc( cur_paramlist_tokens, cur_paramlist_allocated*sizeof(RtToken) );
		cur_paramlist_args = (RtPointer *) realloc( cur_paramlist_args, cur_paramlist_allocated*sizeof(RtPointer) );
		cur_paramlist_sizes = (RtInt *) realloc( cur_paramlist_sizes, cur_paramlist_allocated*sizeof(RtInt) );
	}
	cur_paramlist_tokens[cur_paramlist_size] = yyvsp[-1].string;
	cur_paramlist_sizes[cur_paramlist_size] = yyvsp[0].ribarray->nelems;
	cur_paramlist_args[cur_paramlist_size++] = arg;
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 28:
#line 276 "work/ribparse.y"
{ printf ("RIB Version: %f\n", yyvsp[0].num ); ;
    break;}
case 29:
#line 278 "work/ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to AreaLightSource. Ignoring.", num);
	else
		lights[num] = RiAreaLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 30:
#line 286 "work/ribparse.y"
{
	RiAtmosphereV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 31:
#line 290 "work/ribparse.y"
{
	RiAttributeV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 32:
#line 294 "work/ribparse.y"
{
	RiAttributeBegin();
;
    break;}
case 33:
#line 298 "work/ribparse.y"
{
	RiAttributeEnd();
;
    break;}
case 34:
#line 302 "work/ribparse.y"
{
	RtFloat * basis1 = FindBasis( yyvsp[-3].string );
	RtFloat * basis2 = FindBasis( yyvsp[-1].string );
	RiBasis( basis1, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
;
    break;}
case 35:
#line 308 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 16, "Basis" )) {
		RtFloat * basis1 = FindBasis( yyvsp[-3].string );
		RiBasis( basis1, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 36:
#line 316 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-3].ribarray, 16, "Basis" )) {
		RtFloat * basis2 = FindBasis( yyvsp[-1].string );
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), basis2, RtInt(yyvsp[0].num) );
	}
	ArrayFree( yyvsp[-3].ribarray );
;
    break;}
case 37:
#line 324 "work/ribparse.y"
{
	if (VerifyArrayLength(yyvsp[-3].ribarray, 16, "Basis") && VerifyArrayLength(yyvsp[-1].ribarray, 16, "Basis"))
		RiBasis( (RtFloat *) yyvsp[-3].ribarray->array, RtInt(yyvsp[-2].num), (RtFloat *) yyvsp[-1].ribarray->array, RtInt(yyvsp[0].num) );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 38:
#line 331 "work/ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiBound( bound );
;
    break;}
case 39:
#line 338 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Bound" ))
		RiBound( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 40:
#line 344 "work/ribparse.y"
{
	RiClipping( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 41:
#line 348 "work/ribparse.y"
{
	RtBound color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiColor( color );
;
    break;}
case 42:
#line 354 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Color" ));
		RiColor( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 43:
#line 360 "work/ribparse.y"
{
	if (yyvsp[-1].ribarray->nelems != yyvsp[0].ribarray->nelems) {
		ParseError( "The two arrays should be the same size in ColorSamples" );
		goto noGoodColor;
	}
	if (yyvsp[-1].ribarray->nelems % 3 != 0) {
		ParseError( "The two arrays should be the multiples of 3 in ColorSamples" );
		goto noGoodColor;
	}
	RiColorSamples( yyvsp[-1].ribarray->nelems / 3, NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
noGoodColor:
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 44:
#line 375 "work/ribparse.y"
{
	RiConeV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 45:
#line 379 "work/ribparse.y"
{
	VerifyArrayLength( yyvsp[-1].ribarray, 3, "Cone" );
	RiConeV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
;
    break;}
case 46:
#line 384 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "ConcatTransform" ));
		RiConcatTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 47:
#line 390 "work/ribparse.y"
{
	RiCoordinateSystem( yyvsp[0].string );
;
    break;}
case 48:
#line 394 "work/ribparse.y"
{
	RiCropWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 49:
#line 398 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "CropWindow" ))
		RiCropWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 50:
#line 404 "work/ribparse.y"
{
	RiCylinderV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 51:
#line 408 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Cylinder" ))
		RiCylinderV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 52:
#line 414 "work/ribparse.y"
{
	RiDeclare( yyvsp[-1].string, yyvsp[0].string );
;
    break;}
case 53:
#line 418 "work/ribparse.y"
{
	RiDeformationV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 54:
#line 422 "work/ribparse.y"
{
	RiDepthOfField( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 55:
#line 426 "work/ribparse.y"
{
	RiDepthOfField( RI_INFINITY, 0, 0 );
;
    break;}
case 56:
#line 430 "work/ribparse.y"
{
	RtBound bound;
	bound[0] = yyvsp[-5].num; bound[1] = yyvsp[-4].num; bound[2] = yyvsp[-3].num;
	bound[3] = yyvsp[-2].num; bound[4] = yyvsp[-1].num; bound[5] = yyvsp[0].num;
	RiDetail( bound );
;
    break;}
case 57:
#line 437 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 6, "Detail" ))
		RiDetail( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 58:
#line 443 "work/ribparse.y"
{
	RiDetailRange( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 59:
#line 447 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "DetailRange" ))
		RiDetailRange( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 60:
#line 453 "work/ribparse.y"
{
	RiDiskV( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 61:
#line 457 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 3, "Disk" ))
		RiDiskV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 62:
#line 463 "work/ribparse.y"
{
	RiDisplacementV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 63:
#line 467 "work/ribparse.y"
{
	RiDisplayV( yyvsp[-3].string, yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 64:
#line 471 "work/ribparse.y"
{
	RiExposure( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 65:
#line 475 "work/ribparse.y"
{
	RiExteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 66:
#line 479 "work/ribparse.y"
{
	RiFormat( RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 67:
#line 483 "work/ribparse.y"
{
	RiFrameAspectRatio( yyvsp[0].num );
;
    break;}
case 68:
#line 487 "work/ribparse.y"
{
	RiFrameBegin( RtInt(yyvsp[0].num) );
;
    break;}
case 69:
#line 491 "work/ribparse.y"
{
	RiFrameEnd();
;
    break;}
case 70:
#line 495 "work/ribparse.y"
{
	RtInt *verts = MakeIntArray( yyvsp[-1].ribarray );
	RiGeneralPolygonV( yyvsp[-1].ribarray->nelems, verts, CPS, CPT, CPA );
	delete [] verts;
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 71:
#line 502 "work/ribparse.y"
{
	RiGeometricApproximation( yyvsp[-1].string, yyvsp[0].num );
;
    break;}
case 72:
#line 506 "work/ribparse.y"
{
	RiGeometryV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 73:
#line 510 "work/ribparse.y"
{
	RiHiderV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 74:
#line 514 "work/ribparse.y"
{
	RtPoint point1, point2;
	point1[0] = yyvsp[-7].num; point1[1] = yyvsp[-6].num; point1[2] = yyvsp[-5].num;
	point2[0] = yyvsp[-4].num; point2[1] = yyvsp[-3].num; point2[2] = yyvsp[-2].num;
	RiHyperboloidV( point1, point2, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 75:
#line 521 "work/ribparse.y"
{
	RtBound point1, point2;
	if (VerifyArrayLength( yyvsp[-1].ribarray, 7, "Hyperboloid" )) {
		point1[0] = NA(yyvsp[-1].ribarray)[0]; point1[1] = NA(yyvsp[-1].ribarray)[1]; point1[2] = NA(yyvsp[-1].ribarray)[2];
		point2[0] = NA(yyvsp[-1].ribarray)[3]; point2[1] = NA(yyvsp[-1].ribarray)[4]; point2[2] = NA(yyvsp[-1].ribarray)[5];
		RiHyperboloidV( point1, point2, NA(yyvsp[-1].ribarray)[6], CPS, CPT, CPA );
	}
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 76:
#line 531 "work/ribparse.y"
{
	RiIdentity();
;
    break;}
case 77:
#line 535 "work/ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to Illuminate. Ignoring.", num);
	else {
		RtLightHandle light = lights[num];
		if (light == (RtLightHandle)RI_NULL)
			ParseError( "Unknown light number: %d", num);
		else
			RiIlluminate( light, (RtBoolean) yyvsp[0].num );
	}
;
    break;}
case 78:
#line 548 "work/ribparse.y"
{
	RiImagerV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 79:
#line 552 "work/ribparse.y"
{
	RiInteriorV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 80:
#line 556 "work/ribparse.y"
{
    int num = (int)yyvsp[-1].num;
	if (num < 0 || num >= MAX_LIGHT_HANDLE)
		Error("Invalid light handle %d passed to LightSource. Ignoring.", num);
	else
		lights[num] = RiLightSourceV( yyvsp[-2].string, CPS, CPT, CPA );
;
    break;}
case 81:
#line 564 "work/ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeBumpV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 82:
#line 569 "work/ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeCubeFaceEnvironmentV( yyvsp[-11].string, yyvsp[-10].string, yyvsp[-9].string, yyvsp[-8].string, yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].num, filterfunc,
		yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 83:
#line 575 "work/ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeLatLongEnvironmentV( yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-2].num, CPS, CPT, CPA );
;
    break;}
case 84:
#line 580 "work/ribparse.y"
{
	RiMakeShadowV( yyvsp[-2].string, yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 85:
#line 584 "work/ribparse.y"
{
	RtFilterFunc filterfunc = FindFilterFunc( yyvsp[-3].string );
	RiMakeTextureV( yyvsp[-7].string, yyvsp[-6].string, yyvsp[-5].string, yyvsp[-4].string, filterfunc, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 86:
#line 589 "work/ribparse.y"
{
	RiMatte( yyvsp[0].num != 0. );
;
    break;}
case 87:
#line 593 "work/ribparse.y"
{
	RiMotionBeginV( yyvsp[0].ribarray->nelems, NA(yyvsp[0].ribarray) );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 88:
#line 598 "work/ribparse.y"
{
	RiMotionEnd();
;
    break;}
case 89:
#line 602 "work/ribparse.y"
{
	RiNuPatchV( RtInt(yyvsp[-10].num), RtInt(yyvsp[-9].num), NA(yyvsp[-8].ribarray), yyvsp[-7].num, yyvsp[-6].num,
				RtInt(yyvsp[-5].num), RtInt(yyvsp[-4].num), NA(yyvsp[-3].ribarray), yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
	ArrayFree(yyvsp[-8].ribarray);
	ArrayFree(yyvsp[-3].ribarray);
;
    break;}
case 90:
#line 609 "work/ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 91:
#line 613 "work/ribparse.y"
{
	RiObjectEnd();
;
    break;}
case 92:
#line 617 "work/ribparse.y"
{
	Warning( "Don't know how to parse ObjectInstance" );
;
    break;}
case 93:
#line 621 "work/ribparse.y"
{
	RtColor color;
	color[0] = yyvsp[-2].num; color[1] = yyvsp[-1].num; color[2] = yyvsp[0].num;
	RiOpacity( color );
;
    break;}
case 94:
#line 627 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 3, "Opacity" ))
		RiOpacity( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 95:
#line 633 "work/ribparse.y"
{
	RiOptionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 96:
#line 637 "work/ribparse.y"
{
	RiOrientation( yyvsp[0].string );
;
    break;}
case 97:
#line 641 "work/ribparse.y"
{
	RiParaboloidV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 98:
#line 645 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Paraboloid" ))
		RiParaboloidV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 99:
#line 651 "work/ribparse.y"
{
	RiPatchV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 100:
#line 655 "work/ribparse.y"
{
	RiPatchMeshV( yyvsp[-5].string, RtInt(yyvsp[-4].num), yyvsp[-3].string, RtInt(yyvsp[-2].num), yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 101:
#line 659 "work/ribparse.y"
{
	RiPerspective( yyvsp[0].num );
;
    break;}
case 102:
#line 663 "work/ribparse.y"
{
	RtFilterFunc func = FindFilterFunc( yyvsp[-2].string );
	RiPixelFilter( func, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 103:
#line 668 "work/ribparse.y"
{
	RiPixelSamples( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 104:
#line 672 "work/ribparse.y"
{
	RiPixelVariance( yyvsp[0].num );
;
    break;}
case 105:
#line 676 "work/ribparse.y"
{
	RtInt *nloops, *nvertices, *vertices;

	nloops = MakeIntArray( yyvsp[-3].ribarray );
	nvertices = MakeIntArray( yyvsp[-2].ribarray );
	vertices = MakeIntArray( yyvsp[-1].ribarray );

	RiPointsGeneralPolygonsV( yyvsp[-3].ribarray->nelems, nloops, nvertices, vertices, CPS, CPT, CPA );

	delete [] nloops;
	delete [] nvertices;
	delete [] vertices;
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 106:
#line 693 "work/ribparse.y"
{
	// Gotta convert these bad boys to arrays of integers.  that sucks.
	RtInt *nverts, *verts;

	nverts = MakeIntArray( yyvsp[-2].ribarray );
	verts = MakeIntArray( yyvsp[-1].ribarray );
	int tot = 0;
	for (int i = 0 ; i < yyvsp[-2].ribarray->nelems ; i++)
		tot += nverts[i];
	if (tot != yyvsp[-1].ribarray->nelems)
		ParseError("Wrong number of vertex elements in PointsPolygons. Ignoring.");
	else
		RiPointsPolygonsV( yyvsp[-2].ribarray->nelems, nverts, verts, CPS, CPT, CPA );

	delete [] nverts;
	delete [] verts;
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 107:
#line 713 "work/ribparse.y"
{
	RtInt num_verts = -1;

	for (int i = 0 ; i < CPS ; i++) {
		if (CPT[i] == RI_P || strcmp(CPT[i], RI_P) == 0) {
			num_verts = CPSZ[i];
			if (num_verts % 3 != 0) {
				ParseError( "RI_P array must be 3*n in length." );
				goto noGoodPolygon;
			}
			num_verts /= 3;
			break;
		}
	}
	if (num_verts == -1)
		ParseError( "Polygon without an RI_P parameter???" );
	else
		RiPolygonV( num_verts, CPS, CPT, CPA );
noGoodPolygon:
	;
;
    break;}
case 108:
#line 735 "work/ribparse.y"
{
	RiProjectionV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 109:
#line 739 "work/ribparse.y"
{
	RiQuantize( yyvsp[-4].string, RtInt(yyvsp[-3].num), RtInt(yyvsp[-2].num), RtInt(yyvsp[-1].num), yyvsp[0].num );
;
    break;}
case 110:
#line 743 "work/ribparse.y"
{
	RiRelativeDetail( yyvsp[0].num );
;
    break;}
case 111:
#line 747 "work/ribparse.y"
{
	RiReverseOrientation();
;
    break;}
case 112:
#line 751 "work/ribparse.y"
{
	RiRotate( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 113:
#line 755 "work/ribparse.y"
{
	RiScale( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 114:
#line 759 "work/ribparse.y"
{
	RiScreenWindow( yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 115:
#line 763 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 4, "ScreenWindow" ))
		RiScreenWindow( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 116:
#line 769 "work/ribparse.y"
{
	RiShadingInterpolation( yyvsp[0].string );
;
    break;}
case 117:
#line 773 "work/ribparse.y"
{
	RiShadingRate( yyvsp[0].num );
;
    break;}
case 118:
#line 777 "work/ribparse.y"
{
	RiShutter( yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 119:
#line 781 "work/ribparse.y"
{
	RiSides( RtInt(yyvsp[0].num) );
;
    break;}
case 120:
#line 785 "work/ribparse.y"
{
	RiSkew( yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 121:
#line 789 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 7, "Skew" ))
		RiSkew( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
				NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[6] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 122:
#line 796 "work/ribparse.y"
{
	RiSolidBegin( yyvsp[0].string );
;
    break;}
case 123:
#line 800 "work/ribparse.y"
{
	RiSolidEnd();
;
    break;}
case 124:
#line 804 "work/ribparse.y"
{
	RiSphereV( yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 125:
#line 808 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 4, "Sphere" ))
		RiSphereV( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], CPS, CPT, CPA );
	ArrayFree( yyvsp[-1].ribarray );
;
    break;}
case 126:
#line 814 "work/ribparse.y"
{
	RiSurfaceV( yyvsp[-1].string, CPS, CPT, CPA );
;
    break;}
case 127:
#line 818 "work/ribparse.y"
{
	RiTextureCoordinates( yyvsp[-7].num, yyvsp[-6].num, yyvsp[-5].num, yyvsp[-4].num,
						  yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 128:
#line 823 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 8, "TextureCoordinates" ))
		RiTextureCoordinates( NA(yyvsp[0].ribarray)[0], NA(yyvsp[0].ribarray)[1], NA(yyvsp[0].ribarray)[2], NA(yyvsp[0].ribarray)[3],
							  NA(yyvsp[0].ribarray)[4], NA(yyvsp[0].ribarray)[5], NA(yyvsp[0].ribarray)[7], NA(yyvsp[0].ribarray)[8] );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 129:
#line 830 "work/ribparse.y"
{
	RiTorus( yyvsp[-5].num, yyvsp[-4].num, yyvsp[-3].num, yyvsp[-2].num, yyvsp[-1].num, CPS, CPT, CPA );
;
    break;}
case 130:
#line 834 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[-1].ribarray, 5, "Torus" ))
		RiTorus( NA(yyvsp[-1].ribarray)[0], NA(yyvsp[-1].ribarray)[1], NA(yyvsp[-1].ribarray)[2], NA(yyvsp[-1].ribarray)[3], NA(yyvsp[-1].ribarray)[4],
			CPS, CPT, CPA );
    ArrayFree(yyvsp[-1].ribarray);
;
    break;}
case 131:
#line 841 "work/ribparse.y"
{
	if (VerifyArrayLength( yyvsp[0].ribarray, 16, "Transform" ))
		RiTransform( (RtFloat *) yyvsp[0].ribarray->array );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 132:
#line 847 "work/ribparse.y"
{
	RiTransformBegin();
;
    break;}
case 133:
#line 851 "work/ribparse.y"
{
	RiTransformEnd();
;
    break;}
case 134:
#line 855 "work/ribparse.y"
{
	RiTranslate( yyvsp[-2].num, yyvsp[-1].num, yyvsp[0].num );
;
    break;}
case 135:
#line 859 "work/ribparse.y"
{
	RtInt *ncurves, *order, *n;

	ncurves = MakeIntArray( yyvsp[-8].ribarray );
	order = MakeIntArray( yyvsp[-7].ribarray );
	n = MakeIntArray( yyvsp[-3].ribarray );

	RiTrimCurve( yyvsp[-8].ribarray->nelems, ncurves, order, NA(yyvsp[-6].ribarray), NA(yyvsp[-5].ribarray), NA(yyvsp[-4].ribarray), n, NA(yyvsp[-2].ribarray), NA(yyvsp[-1].ribarray), NA(yyvsp[0].ribarray) );
	delete [] ncurves;
	delete [] order;
	delete [] n;

	ArrayFree( yyvsp[-8].ribarray );
	ArrayFree( yyvsp[-7].ribarray );
	ArrayFree( yyvsp[-6].ribarray );
	ArrayFree( yyvsp[-5].ribarray );
	ArrayFree( yyvsp[-4].ribarray );
	ArrayFree( yyvsp[-3].ribarray );
	ArrayFree( yyvsp[-2].ribarray );
	ArrayFree( yyvsp[-1].ribarray );
	ArrayFree( yyvsp[0].ribarray );
;
    break;}
case 136:
#line 882 "work/ribparse.y"
{
	RiWorldBegin();
;
    break;}
case 137:
#line 886 "work/ribparse.y"
{
	RiWorldEnd();
;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 498 "/usr/common/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 889 "work/ribparse.y"

