#include "lrt.h"
#include "scene.h"
#include "sampling.h"
#include "image.h"
Float BoxFilter::Apply(Float x, Float y, Float xwidth, Float ywidth) {
	if (x >= -xwidth * 0.5 && x <= xwidth * 0.5 &&
		y >= -ywidth * 0.5 && y <= ywidth * 0.5)
		return 1.;
	else return 0.;
}
Float TriangleFilter::Apply(Float x, Float y, Float xwidth, Float ywidth) {
	if (x >= -xwidth * 0.5 && x <= xwidth * 0.5 &&
		y >= -ywidth * 0.5 && y <= ywidth * 0.5)
		return (xwidth * 0.5 - fabs(x)) * (ywidth * 0.5 - fabs(y));
	else return 0.;
}
Float GaussianFilter::Apply(Float x, Float y, Float xwidth, Float ywidth) {
	Float d2 = (x*x+y*y);
	Float d = sqrt( d2 );
	Float w2 = 0.5*(xwidth*xwidth + ywidth*ywidth);
	Float w = sqrt( w2 );
	if (d > w)
		return 0.0;
	else
		return exp(-d2) - exp(-w2);
}
Float MitchellFilter::Apply(Float x, Float y, Float xwidth,
		Float ywidth) {
	x /= xwidth;
	y /= ywidth;
	Float r = sqrt(x*x + y*y);
	if (r > 2.) return 0.;
#define B .33333333333333333
#define C .33333333333333333
#define ONE_SIXTH .166666666666666666
	else if (r > 1.)
		return ((-B - 6.*C) * r*r*r + (6.*B + 30.*C) * r*r +
			(-12.*B - 48.*C) * r + (8.*B + 24.*C)) * ONE_SIXTH;
	else
		return ((12. - 9.*B - 6.*C) * r*r*r +
			(-18. + 12.*B + 6.*C) * r*r +
			(6. - 2.*B)) * ONE_SIXTH;
#undef B
#undef C
#undef ONE_SIXTH
}
Float GeneralFilter::Apply(Float x, Float y, Float xwidth, Float ywidth) {
	return this->func( x, y, xwidth, ywidth );
}
Sampler::Sampler(int xres, int yres, Filter *filter) {
	XResolution = xres;
	YResolution = yres;
	this->filter = filter;
	FilterXWidth = FilterYWidth = 1.;
}
JitterSampler::JitterSampler(int xres, int yres, Float xSamples,
		Float ySamples, bool jitter, Filter *filter)
	: Sampler(xres, yres, filter) {
	PixelSamples[0] = xSamples;
	PixelSamples[1] = ySamples;
	JitterSamples = jitter;
	XMin = 0;
	YMin = 0;
	XPos = XMin - 1;
	YPos = YMin;
	XMax = (int)ceil(XResolution * PixelSamples[0]);
	YMax = (int)ceil(YResolution * PixelSamples[1]);
	DeltaX = 1. / PixelSamples[0];
	DeltaY = 1. / PixelSamples[1];
}

JitterSampler::JitterSampler(int xmin, int ymin, int xmax, int ymax,
			     Float xSamples, Float ySamples, bool jitter,
			     Filter *filter)
  : Sampler(xmax, ymax, filter) {
  PixelSamples[0] = xSamples;
  PixelSamples[1] = ySamples;
  JitterSamples = jitter;
  XMin = ((int)ceil(xmin*PixelSamples[0]));
  YMin = ((int)ceil(ymin*PixelSamples[1]));
  XPos = XMin - 1;
  YPos = YMin;
  XMax = (int)ceil(XResolution * PixelSamples[0]);
  YMax = (int)ceil(YResolution * PixelSamples[1]);
  DeltaX = 1. / PixelSamples[0];
  DeltaY = 1. / PixelSamples[1];
}

bool JitterSampler::GetNextImageSample(Float sample[5]) {
	if (++XPos >= XMax) {
		XPos = XMin;
		if (++YPos >= YMax)
			return false;
	}
	if (JitterSamples) {
		sample[0] = (XPos + RandomFloat()) * DeltaX;
		sample[1] = (YPos + RandomFloat()) * DeltaY;
		sample[2] = RandomFloat();
		sample[3] = RandomFloat();
		sample[4] = RandomFloat();
	}
	else {
		sample[0] = (XPos + 0.5) * DeltaX;
		sample[1] = (YPos + 0.5) * DeltaY;
		sample[2] = 0.5;
		sample[3] = 0.5;
		sample[4] = 0.5;
	}
	return true;
}
GeneralSampler::GeneralSampler(int xres, int yres, Filter *filter)
	: Sampler(xres, yres, filter) {
	x0 = 0.;
	y0 = 0.;
	DeltaX = (Float)SQRT_SAMPLE_TABLE_SIZE / PixelSamples[0];
	DeltaY = (Float)SQRT_SAMPLE_TABLE_SIZE / PixelSamples[1];
	printf("%g %g\n", PixelSamples[0], PixelSamples[1]);
	tablePos = -1;
}



#include "sampledata.cc"
bool GeneralSampler::GetNextImageSample(Float sample[5]) {
	if (++tablePos >= SAMPLE_TABLE_SIZE) {
		tablePos = 0;
		x0 += DeltaX;
		if (x0 >= XResolution) {
			x0 = 0.;
			y0 += DeltaY;
			printf("%g %d\n", y0, YResolution);
			if (y0 >= YResolution)
				return false;
		}
	}
	sample[0] = x0 + DeltaX * sampleTable[tablePos][0];
	sample[1] = y0 + DeltaY * sampleTable[tablePos][1];
	sample[2] = sampleTable[tablePos][2];
	sample[3] = sampleTable[tablePos][3];
	sample[4] = sampleTable[tablePos][4];
	return true;
}
