#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"
#include "densitygrid.h"
class Scene {
public:
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts);
	Spectrum L(const Ray &ray) const;
	bool Intersect(const Ray &ray, Surf *surf) const;
	bool IntersectP( const Ray &ray ) const;
	void Render();
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
	DensityGrid *densityGrid;
private:
	PrimitiveSet *prims;
	void SetupAutomaticCamera();
	Spectrum CalculateVolumeSpectrum (Ray &ray, Float &alpha);
};
#endif // SCENE_H
