function [vel,W,X,Y,Z] = gen_density(maxX, maxY, maxZ, nx, ny, nz)
x = 0:(maxX/nx):maxX;
y = 0:(maxY/ny):maxY;
z = 0:(maxZ/nz):maxZ;
x = x(1:nx);
y = y(1:ny);
z = z(1:nz);
R = (nx+1)/2;
[X,Y,Z] = meshgrid(x,y,z);
for i=1:nx
    for j=1:ny
        for k=1:nz
            vel(i,j,k) = [
            r = norm([(i-(nx+1)/2) (j-(ny+1)/2) (k-(nz+1)/2)]);
            if (r>=R) W(i,j,k) = 0;
            else W(i,j,k) = -4*(r/R)^6/9 + 17*(r/R)^4/9 - 22*(r/R)^2/9 + 1;
            end
        end
    end
end            
return