function S1 = transport(S0, U1, dt)
global x;
global y;
global z;
dx(1) = x(2)-x(1);
dx(2) = y(2)-y(1);
dx(3) = z(2)-z(1);
for (i=1:size(S0,1))
    for (j=1:size(S0,2))
        for (k=1:size(S0,3))
            pos = [i j k];
            pos = (pos.*dx)-dx;
            vel = [U1(i,j,k,1) U1(i,j,k,2) U1(i,j,k,3)]*-dt;
            pos2 = bound(pos + vel);
            for (l=1:3)
                vel2(l) = lin_interp(pos2, U1(:,:,:,l))*-dt;
            end
            vel3 = (vel+vel2)/2;
            pos3 = bound(pos + vel3);
            S1(i,j,k) = lin_interp(pos3, S0);
        end
    end
end