function W = update_density(t, dt)
global visc;
global kS;
global visc;
global aS;

nx = 10;
ny = 10;
nz = 10;

visc = 0.1;
kS = 0.1;
aS = 0.2;

[U,V,X,Y,Z] = gen_init(5, 5, 5, 10, 10, 10);
F = zeros(nx, ny, nz, 3);
U = zeros(nx, ny, nz, 3);
source = zeros(nx, ny, nz);
V = zeros(nx,ny,nz);
source(1,:,:) = rand(10, 10)*0.1;

filenumber = 0;
    
output = real(V);
[filename, errmsg] = sprintf('test-%d.den', filenumber);
filenumber = filenumber+1;
fid = fopen (filename, 'w');
for i=1:size(output,1)
    for j=1:size(output,2)
        fprintf(fid, '%8.3f ', output(i,j,1:size(output,3)));
        fprintf(fid, '\n');
    end
    fprintf(fid, '\n');
end
fclose(fid);

for k = 0:dt:t
    
    F(:,:,:,1) = rand(10,10,10)*4;
    F(:,:,:,2) = rand(10,10,10)*4-2;
    F(:,:,:,3) = rand(10,10,10)*4-2;
    
    %introduce random counter-velocities
    for count1=1:15
        randx = floor(rand*10)+1;
        randy = floor(rand*10)+1;
        randz = floor(rand*10)+1;
        for count2=-1:1
            for count3=-1:1
                for count4=-1:1
                    F(mod(randx+count2, 10)+1, ...
                      mod(randy+count3, 10)+1, ...
                      mod(randz+count4, 10)+1, 1) = rand*-4;
                end
            end
        end
    end
    
    vels = v_step(U, F, dt);
    W = s_step(V, U, source, dt);
    U = vels;
    V = W;
 
    output = real(W);
    [filename, errmsg] = sprintf('test-%d.den', filenumber);
    filenumber = filenumber+1;
    fid = fopen (filename, 'w');
    for i=1:size(output,1)
        for j=1:size(output,2)
            fprintf(fid, '%8.3f ', output(i,j,1:size(output,3)));
            fprintf(fid, '\n');
        end
        fprintf(fid, '\n');
    end
    fclose(fid);
end
return