#ifndef SAMPLING_H
#define SAMPLING_H
#include "lrt.h"
#define SQRT_SAMPLE_TABLE_SIZE 32
#define SAMPLE_TABLE_SIZE (SQRT_SAMPLE_TABLE_SIZE * SQRT_SAMPLE_TABLE_SIZE)
class Sampler {
public:
	Sampler(int xres, int yres, Filter *filter);
	virtual ~Sampler() { }
	virtual bool GetNextImageSample(Float sample[5]) = 0;
	int XResolution, YResolution;
	Filter *filter;
	Float PixelSamples[2];
	int XMax, YMax;
	Float DeltaX, DeltaY;
	bool JitterSamples;
	Float FilterXWidth, FilterYWidth;
};
class JitterSampler : public Sampler {
public:
	JitterSampler(int XResolution, int YResolution, Float xSamples,
		Float ySamples, bool jitter, Filter *filter);
	bool GetNextImageSample(Float sample[5]);
private:
	int XPos, YPos;
};
class GeneralSampler : public Sampler {
public:
	GeneralSampler(int xres, int yres, Filter *filter);
	bool GetNextImageSample(Float sample[5]);
private:
	static const Float sampleTable[SAMPLE_TABLE_SIZE][5];
	int tablePos;
	Float x0, y0;
	Float DeltaX, DeltaY;
};
class Filter {
public:
	Filter() { };
	virtual ~Filter() { }
	virtual Float Apply( Float x, Float y, Float xwidth, Float ywidth ) = 0;
};
class BoxFilter: public Filter {
public:
	BoxFilter(): Filter() { };
	~BoxFilter() { }
	Float Apply( Float x, Float y, Float xwidth, Float ywidth );
};
class TriangleFilter: public Filter {
public:
	TriangleFilter(): Filter() { };
	~TriangleFilter() { }
	Float Apply( Float x, Float y, Float xwidth, Float ywidth );
};
class GaussianFilter: public Filter {
public:
	GaussianFilter(): Filter() { };
	~GaussianFilter() { }
	Float Apply( Float x, Float y, Float xwidth, Float ywidth );
};
class MitchellFilter: public Filter {
public:
	MitchellFilter(): Filter() { };
	~MitchellFilter() { }
	Float Apply( Float x, Float y, Float xwidth, Float ywidth );
};
class GeneralFilter: public Filter {
public:
	~GeneralFilter() { }
	Float Apply( Float x, Float y, Float xwidth, Float ywidth );
	typedef Float (*filterfunc)(Float, Float, Float, Float);
	GeneralFilter( filterfunc func ) : Filter() { this->func = func; }
protected:
	filterfunc func;
};
#endif // SAMPLING_H
