#ifndef SCENE_H
#define SCENE_H
#include "lrt.h"

class Photon_map;
class GlobalPhotonMap;

class Scene {
public:
	Scene(Camera *c, Integrator *in, Image *img, Sampler *s,
		const vector<Primitive *> &prims, const vector<Light *> &lts);
	Spectrum L(const Ray &ray) const;
	bool Intersect(const Ray &ray, Surf *surf) const;
	bool IntersectP( const Ray &ray ) const;
	void Render();
	~Scene();
	Integrator *integrator;
	Camera *camera;
	Image *image;
	Sampler *sampler;
	vector<Light *> lights;
    Photon_map* pMap;
    GlobalPhotonMap* gpMap;
    GlobalPhotonMap* gpMapTerrain;
private:
	PrimitiveSet *prims;
};
#endif // SCENE_H
