#include "lrt.h"
#include "primitives.h"
#include "color.h"
#include "light.h"
#include "scene.h"
#include "reflection.h"
#include "sampling.h"
#include "materials.h"
#include "transport.h"
Integrator::~Integrator() {
}
Spectrum RayCastingIntegrator::L(const Scene *scene,
		const Ray &ray, Float *alpha) const {
	Surf surf;
	if (scene->Intersect(ray, &surf)) {
		Spectrum L(0.);
		if (alpha) *alpha = 1.;
		L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		for (u_int i = 0; i < (scene->lights.size() - 1); ++i) {
			Spectrum dE = scene->lights[i]->dE(scene, surf.dgShading, &wi);
			L += bsdf->f(-ray.D, wi) * dE;
		}
		delete bsdf;
		return L;
	}
	else {
		if (alpha) *alpha = 0.;
		return Spectrum(0.);
	}
}
Spectrum WhittedIntegrator::L(const Scene *scene, const Ray &ray,
		Float *alpha) const {
	Surf surf;
    Ray cpRay = ray; // make a copy of the ray
	if (scene->Intersect(ray, &surf)) {
		Spectrum L(0.);
		if (alpha) *alpha = 1.;
		L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
        // TODO : add code here to recursively         
#if 1
        Float sigmaS = 5.0f, sigmaA = 0.045f;
        Float sigmaT = sigmaS + sigmaA;
        
        Float distanceToTravel = Distance(cpRay.O, surf.dgShading.P);        
        Float dx = (1.0f/sigmaT) + RandomFloat(-0.05f, 0.05f);
        dx /= 4;
        int numSteps = (int)(distanceToTravel/dx);
        Float distanceTraveledSoFar = 0.0f;

        Spectrum Lv(0.);
        // march along the ray with dx step size
        for(int j = 0; j < numSteps; ++j) {
            Point curPos = cpRay(distanceTraveledSoFar);
            // Calculate sum Li*pTheta*sigmaS*dx  for all lights
            // where Li is the radiance of light i
            Spectrum Ll(0.);
          	for (u_int i = 1; i < scene->lights.size(); ++i) {
                Light *lt = scene->lights[i];
                PointLight* light;
                if( (light = dynamic_cast<PointLight*>(lt)));                
                else continue;
                Spectrum dEi(0.);
//                if (light->visible(scene, curPos, light->lightPos)) {
		Vector wpos;// = light->lightPos - curPos; handle point lights only
		dEi = light->I(wpos) / DistanceSquared(light->lightPos, curPos);
			//              }
//                else
			//                  continue;
                // Use Schlick phase function for forward scattering
                // 0 gives isotropic scattering
                // -ve gives backward and +ve foward scattering
                Float k = 0.1f;
                Float Zeta = RandomFloat(0.0f, 1.0f);
                Float cosTheta = (2*Zeta + k - 1) / (2*k*Zeta - k + 1);

                Float pTheta = (1 - k*k) / (4*M_PI*(1 + k*cosTheta)*(1 + k*cosTheta));
                // attenuate the light reaching this point due to atmosphere
                Spectrum Li = dEi ;//* expf(-sigmaA*Distance(light->lightPos, curPos));
                Li *= pTheta*sigmaS*dx;
                Ll += Li; // sum up all for light sources			    
		    }
		distanceTraveledSoFar += dx;
            if(Ll.Intensity() == 0)
                continue;
            Lv = Ll + expf(-sigmaT*dx)*Lv;
            // move the ray forward       

           // cerr << Ll << endl;
        }

        L += Lv;
        //cerr << Lv << endl;
#endif

#if 1
        // handle transluscent material
        if(surf.primitive->material->getType() == TRANSLUSCENT) {
            Spectrum scatterRad(0.);
            gpMap->ComputeBSSRDFRadiance(scatterRad, surf, -ray.D);
	     L += scatterRad;
//            cerr << scatterRad << endl;
	         }
        else if(surf.primitive->material->getType() == TRANSLUSCENT_TERRAIN) {
            Spectrum scatterRad(0.);
	              gpMapTerrain->ComputeBSSRDFRadianceTerrain(scatterRad, surf, -ray.D);
	             L += scatterRad;
//            cerr << scatterRad << endl;
         }
        else {
		    for (u_int i = 0; i < (scene->lights.size() - 1); ++i) {
			    Spectrum dE = scene->lights[i]->dE(scene, surf.dgShading, &wi);
			    L += bsdf->f(-ray.D, wi) * dE;
	      	    }
	
	}
#endif
        // add photon mapping estimate       
#if 1
        Spectrum est(0.);
	Vector wiw = -ray.D;
        pMap->radiance_estimate(est, bsdf, wiw, 
            surf.dgGeom.P, surf.dgShading.N, 10.0f, 200); 
        L += est;
#endif

		if (++RayDepth < MaxDepth) {
			for (int i = 0; i < bsdf->NumSpecular(); ++i) {
				Spectrum fr = bsdf->f_delta(i, -ray.D, &wi);
				if (fr != Spectrum(0.))
					L += scene->L(Ray(surf.dgShading.P, wi)) * fr;
			}
		}
		--RayDepth;
		delete bsdf;
		return L;
	}
	else {
		if (alpha) *alpha = 0.;
		return Spectrum(0.);
	}
}
int WhittedIntegrator::RayDepth = 0;
Spectrum PathIntegrator::L(const Scene *scene,
		const Ray &r, Float *alpha) const {
	Spectrum pathWeight = 1.;
	Spectrum L = 0.;
	Ray ray = r;
	if (alpha) *alpha = 1.;
	int pathLength = 0;
	while (1) {
		Surf surf;
		if (!scene->Intersect(ray, &surf)) {
			if (pathLength == 0 && alpha) *alpha = 0.;
			break;
		}
		if (pathLength == 0)
			L += surf.Le(-ray.D);
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		Float weight;
		int lightNum = int(RandomFloat() * (scene->lights.size()-1));
		const Light *light = scene->lights[lightNum];
		Spectrum dE = light->sample_dE(scene,
			surf.dgShading, &wi, &weight);
		L += pathWeight * weight * bsdf->f(-ray.D, wi) * dE;
		Spectrum f = bsdf->sample_f(-ray.D, &wi);
		weight = bsdf->weight(-ray.D, wi);
		if (f == Spectrum(0.) || weight == 0.)
			break;
		pathWeight *= f * weight * fabs(Dot(wi.Hat(), surf.dgShading.N.Hat()));
		ray = Ray(surf.dgGeom.P, wi);
		delete bsdf;
		if (pathLength > 3 && pathWeight.Intensity() < .1) {
			Float rrProbability = .8;
			if (RandomFloat() < rrProbability)
				break;
			pathWeight /= 1. - rrProbability;
		}
		++pathLength;
	}
	return L;
}
Spectrum MCIntegrator::L(const Scene *scene,
		const Ray &r, Float *alpha) const {
	Spectrum pathWeight = 1.;
	Spectrum L = 0.;
	Ray ray = r;
	if (alpha) *alpha = 1.;
	int pathLength = 0;
	while (1) {
		Surf surf;
		if (!scene->Intersect(ray, &surf)) {
			if (pathLength == 0 && alpha) *alpha = 0.;
			break;
		}
		BSDF *bsdf = surf.getBSDF();
		Vector wi;
		Float weight, lightWeight, bsdfWeight;
		int lightNum = int(RandomFloat() * (scene->lights.size()-1));
		const Light *light = scene->lights[lightNum];
		Spectrum dE = light->sample_dE(scene, surf.dgShading, &wi, &lightWeight);
		bsdfWeight = bsdf->weight(-ray.D, wi);
		weight = .5 * lightWeight + .5 * bsdfWeight;
		L += pathWeight * weight * bsdf->f(-ray.D, wi) * dE;

        // add photon mapping estimate        
//        Spectrum est;
		//      pMap->radiance_estimate(est, bsdf, -ray.D, 
//            surf.dgGeom.P, surf.dgShading.N, 10.0f, 200); 
		//      L += est;

		Spectrum f = bsdf->sample_f(-ray.D, &wi);
		bsdfWeight = bsdf->weight(-ray.D, wi);
		lightWeight = 0;
		for (u_int i = 0; i < (scene->lights.size()-1); ++i)
			lightWeight += scene->lights[i]->weight(surf.dgGeom.P, wi);
		lightWeight /= (scene->lights.size()-1);
		weight = .5 * lightWeight + .5 * bsdfWeight;
		if (f == Spectrum(0.) || weight == 0.)
			break;
		pathWeight *= f * weight * fabs(Dot(wi.Hat(), surf.dgShading.N.Hat()));
		ray = Ray(surf.dgGeom.P, wi);
		delete bsdf;
		if (pathLength > 3 && pathWeight.Intensity() < .1) {
			Float rrProbability = .8;
			if (RandomFloat() < rrProbability)
				break;
			pathWeight /= 1. - rrProbability;
		}
		++pathLength;
	}
	return L;
}
