#include <glut.h>
#include <scene.h>
#include "camera.h"
#include "geometry.h"
#include "../../shapes/trianglemesh.h"

#include "flow.h"

#define WINDOW_WIDTH 800
#define WINDOW_HEIGHT 600

static float g_lightPos[4] = { 10, 10, -100, 1 };  // Position of light

static GLuint window;
static GLvoid *font = GLUT_BITMAP_HELVETICA_18;
static int windowWidth, windowHeight;
static float nearPlane = 1, farPlane = 3000;

extern const Scene *scene;

Flow flow;

static bool renderFlag = TRUE;

static void setLight()
{
	//GLfloat LampPosition[]={-100, 0, 50, 1};
	GLfloat LampPosition[]={1000, -1800, 1200, 1};
	GLfloat LampAmbient[] = { 0.0, 0.0, 0.0, 1.0 };
	GLfloat LampDiffuse[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat LampSpecular[] = { 0.0, 0.0, 0.0, 1.0 };

	glLightfv(GL_LIGHT1, GL_AMBIENT, LampAmbient);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, LampDiffuse);
	glLightfv(GL_LIGHT1, GL_SPECULAR, LampSpecular);
	glLightfv(GL_LIGHT1, GL_POSITION, LampPosition);

	glEnable(GL_LIGHT1);
	glEnable(GL_LIGHTING);
}

static void setMaterial()
{
	GLfloat MSpecular[]={0, 0, 0, 1};
	GLfloat MShininess[]={0};
	GLfloat MDiffuse[]={1, 1, 1, 1};
	GLfloat MAmbient[]={0.1, 0.1, 0.1, 1};
	GLfloat MEmisson[]={0, 0, 0, 1};

	glMaterialfv(GL_FRONT, GL_SPECULAR, MSpecular);
	glMaterialfv(GL_FRONT, GL_SHININESS, MShininess);
	glMaterialfv(GL_FRONT, GL_AMBIENT,MAmbient);
	glMaterialfv(GL_FRONT, GL_DIFFUSE,MDiffuse);
	glMaterialfv(GL_FRONT, GL_EMISSION,MEmisson);

	glEnable ( GL_COLOR_MATERIAL );
	glColorMaterial ( GL_FRONT, GL_AMBIENT_AND_DIFFUSE );
}

static void myGLInit()
{
	glFrontFace(GL_CCW);
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	
	glClearDepth(1.0f);									// Depth Buffer Setup
	glEnable(GL_DEPTH_TEST);							// Enables Depth Testing
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glDepthMask(GL_TRUE);
	
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	//setLight();
	
	//setMaterial();

	glEnableClientState(GL_VERTEX_ARRAY);
}

static void render()
{
	// meshes
	for (u_int i = 0; i < scene->shapes.size(); i++) {
		scene->shapes[i]->renderGL();
	}
	
	// flow
	flow.renderGL();
}

static void main_display(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	if (renderFlag) {
		render();
	}

	flow.simulate();
    
    glutSwapBuffers();
}

	
static void main_reshape(int width,  int height) 
{
	windowWidth = width;
    windowHeight = height;

    glViewport(0, 0, width, height);
    
	glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	gluPerspective(60, (float) width / height, nearPlane, farPlane);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

#ifdef DEBUG
	gluLookAt(0, -100, 50, 0, 0, 0, 0, 0, 1);
	//gluLookAt(0, -100, -50, 0, 0, 0, 0, 0, 1);
#else
	gluLookAt(100, -800, 200,	0, 0, 200,	0, 0, 1);
#endif
	
}

void Keyboard(unsigned char key, int x, int y)
{
	switch (key) {
	case 'q':
		exit (0);
		break;

	case 'd':
		flow.drop();
		break;

	case 'r':
		renderFlag = !renderFlag;
		break;

	case 'i':
		glRotatef(2, 1, 0, 0);
		break;

	case 'k':
		glRotatef(-2, 1, 0, 0);
		break;

	case 'j':
		glRotatef(2, 0, 0, 1);
		break;

	case 'l':
		glRotatef(-2, 0, 0, 1);
		break;

	case ' ':
		flow.simulate();
		break;
	}
}

void GlutInit()
{
	int argc = 1;
	char* argv[1];
	argv[0] = "dummy"; 

	
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB| GLUT_DEPTH);
	glutInitWindowSize(WINDOW_WIDTH, WINDOW_HEIGHT);
	glutInitWindowPosition(50,50);

    window = glutCreateWindow("flow simulation");
    glutDisplayFunc(main_display);
	glutReshapeFunc(main_reshape);
	glutIdleFunc(main_display );
	glutKeyboardFunc(Keyboard);

	myGLInit();

	flow.init();

	glutMainLoop();
}