#include <vector>
#include <fstream>
using namespace std;

#include "pbrt.h"
#include "geometry.h"
#include "scene.h"
#include "../../shapes/trianglemesh.h"

//#define DEBUG

typedef enum {BOUNCE, FLOW, FLOW_EDGE, ATTACH, FREEFALL, STUCK_FALL, STUCK_GROUND} state_t;

class Particle {
public:
	//void generate();
	void fall();
	void bounce();
	void flow();
	void flowEdge();
	void attach();
	void freefall();
	void setGravity();

	int id;				// particle id
	state_t state;
	Point pos;			// position
	Triangle *tri;		// attached triangle
	Triangle *triPrev; // previously attached triangle

	Vector gravity;		// randomly perturbated gravity

	/* tweakking */
	int edgeCounter;  // number of random move on flat ground
	int simulCounter;
	int flowCounter;
};

class Deposit {
public:
	Deposit(const Particle &particle);
	void renderGL();

	Point pos;
	state_t state;
};

class Flow {
public:
	~Flow() {outputGround.close(); outputSurface.close();};

	void init();
	void drop();
	void simulate();
	void renderGL();
	void writeSurfacePoints();
	void write(const Particle &particle);

	Particle particle;
	vector<Deposit> trace;
	vector<Deposit> stuck;
	Point rainBegin;
	Point rainEnd;
	int particleId;

private:
	ofstream outputGround, outputSurface;
};

