/* CS348C PROGRAMMING ASSIGNMENT 2: B-SPLINE CURVES.

Copyright (c) 1995 The Board of Trustees of The Leland Stanford Junior
University. All rights reserved.

Permission to use, copy, modify and distribute this software for any
purpose is hereby granted without fee, provided that the above
copyright notice and this permission notice appear in all copies of
this software and that you do not sell the software.  Commercial
licensing is available by contacting the author.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

Author:
   Apostolos Lerios
   Computer Science Department
   Stanford University
   U.S.A.
   http://graphics.stanford.edu/~tolis/ */


/* TYPES. */

/* A point in 3D space. */

typedef double Point[3];


/* FUNCTION DECLARATIONS. */

/* C++ linkage convention established, if and only if you use C++. */

#ifdef __cplusplus
extern "C" {
#endif

/* InitSystem() is called once and only once during the execution of
   "scurvy". It provides the spline drawing module "draw.c" with an
   opportunity to perform initialization, such as allocating caches,
   or opening trace files. Also, it supplies basic system parameters,
   whose values will not change throughout "scurvy"'s execution. These
   parameters comprise the following:

   (a) The degree of the spline (guaranteed to be at least 1) given in
   Degree.

   (b) The number of knots given in KnotCount (guaranteed to be at
   least 2). We consider knots to be distinct numbers which may appear
   multiple times in a knot sequence; KnotCount does not reflect these
   multiplicities.

   (c) A pointer to the list of the spline's knots named Knots. That
   is, Knots points to the first element of an array containing a
   total of KnotCount strictly increasing real numbers.

   (d) An array of KnotCount-2 elements (each guaranteed to be between
   1 and Degree+1) named Multiplicities and containing the
   multiplicity of each interior knot. All knots except the first and
   last one are interior ones. The multiplicities of the first and
   last knot are both automatically set to Degree.

   (e) A pointer to the list of the spline's de Boor points named
   deBoorP. That is, deBoorP points to the first element of an array
   containing a total of s+Degree+1 elements, where s is the sum of
   the multiplicities of the interior knots.

   NOTES:

   (a) The contents of the deBoorP and Knots arrays DO change over
   time; however, both arrays are always stored in the SAME portion of
   memory.

   (b) Whenever the contents of the Knots array are modified,
   NewKnots() is called (see below), permitting update of local caches
   (if any). There is no similar notification mechanism for changes
   made in the contents of the deBoorP array.

   (c) The contents of the Multiplicities array DO NOT change over
   time.  Also, the array is always stored in the SAME portion of
   memory and is deallocated right before "scurvy" terminates (even
   after Cleanup() is called; see below). */

void InitSystem(int Degree,
		int KnotCount,
		double *Knots,
		int *Multiplicities,
		Point *deBoorP);


/* NewKnots() is called whenever the values of the spline's knots are
   altered, thus permitting local cache updates. */

void NewKnots(void);


/* GetPointInfluence() places in *FirstSegment and *LastSegment
   respectively the indexes of the first and last spline segment
   affected by the de Boor point whose index is Point. All indexes
   start from 0, which corresponds to the first segment or first de
   Boor point of the spline. Point is guaranteed to contain a legal
   value.

   For example, consider a spline of degree 2, with 3 knots whose
   values are 0, 1, and 2 and multiplicities are respectively 2 (set
   automatically, as stated above), 2, and 2 (also set
   automatically). The de Boor points of the spline correspond to the
   polar arguments 00, 01, 11, 12, and 22; as noted above, the spline
   has s+Degree+1 de Boor points (2+2+1=5) whose indexes are 0 through
   4. For this example, here is what GetPointInfluence() should return
   for the listed values of Point:

   Point              *FirstSegment              *LastSegment
     0                      0                         0
     1                      0                         0
     2                      0                         1
     3                      1                         1
     4                      1                         1

  */

void GetPointInfluence(int Point,
		       int *FirstSegment,
		       int *LastSegment);


/* GetSplinePoint() is supplied the parameter value of interest t, and
   returns in InterpolatedP the (Degree+1)*(Degree+2)/2 points which
   are used while calculating the corresponding spline point by polar
   interpolations. In more detail,

   (a) GetSplinePoint() first associates the parameter value t with a
   spline segment. As a running example, consider a spline of degree
   2, with 3 knots whose values are 0, 1, and 2, and multiplicities
   are respectively 2, 1, and 2. The de Boor points of the spline
   correspond to the polar arguments 00, 01, 12, and 22. For t=1.5,
   the associated segment is the second one since it is traversed when
   t takes values between 1 and 2.

   (b) Then, GetSplinePoint() identifies the Degree+1 de Boor points
   of this segment and copies them, in order, in the InterpolatedP
   array. In our example the de Boor points of the second segment are
   01, 12, and 22, and thus the first three elements of the
   InterpolatedP array should be set to these three de Boor points.

   (c) Finally, GetSplinePoint() performs repeated linear
   interpolations in order to find the spline point, storing all
   interpolation results, in order, in the InterpolatedP array. In our
   example, in the first level of interpolations, the de Boor points
   01 and 12 are interpolated, and the result, whose polar arguments
   are 1t, is placed in the fourth slot of the InterpolatedP
   array. Next, 12 and 22 are interpolated to yield 2t, which is
   placed in the fifth slot of the InterpolatedP array. In the final
   step, the last two non-empty elements of the InterpolatedP array
   are interpolated, and the result, the spline point itself, is
   placed in the last slot of the array. So, in our example, 1t and 2t
   are are interpolated to yield tt, which becomes the sixth and last
   element of the InterpolatedP array.

   Direction is an argument which is relevant only when t happens to
   coincide with a knot. In this case, two adjacent spline segments
   claim ownership of the spline point corresponding to the parameter
   value t: if Direction is -1, then the first of these segments
   should be used in the above interpolations; if Direction is +1, the
   second segment should be used.

   For example, consider a spline of degree 2, with 3 knots whose
   values are 0, 1, and 2, and multiplicities are respectively 2, 3,
   and 2. The de Boor points of the spline correspond to the polar
   arguments 00, 01, 11, 11, 12, and 22. As we can see, when t=1, both
   the first and second spline segment may claim ownership of the
   corresponding spline point. If Direction is -1, then the spline
   point should be found by repeated interpolations from the de Boor
   points 00, 01, and 11. If Direction is +1, the spline point should
   be found by repeated interpolations from the de Boor points 11, 12,
   and 22.

   NOTES:

   (a) The InterpolatedP array is preallocated to a size of
   (Degree+1)*(Degree+2)/2 elements.

   (b) t is guaranteed to lie between or on the first and last knot of
   the spline.

   (c) Most often, but not always, successive calls to
   GetSplinePoint() are passed increasing values of t. */

void GetSplinePoint(double t,
		    int Direction,
		    Point *InterpolatedP);


/* Cleanup() is called once and only once during the execution of
   "scurvy", right before "scurvy" terminates. It provides the spline
   drawing module "draw.c" with an opportunity to perform cleanup of
   its local resources, such as deallocating cache memory or closing
   trace files. */

void Cleanup(void);

#ifdef __cplusplus
}
#endif
